/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator.model;

import java.util.Random;
import org.apache.beam.sdk.nexmark.model.Bid;
import org.apache.beam.sdk.nexmark.sources.generator.GeneratorConfig;
import org.apache.beam.sdk.nexmark.sources.generator.model.AuctionGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.PersonGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.PriceGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.StringsGenerator;

public class BidGenerator {
    private static final int HOT_AUCTION_RATIO = 100;
    private static final int HOT_BIDDER_RATIO = 100;

    public static Bid nextBid(long eventId, Random random, long timestamp, GeneratorConfig config) {
        long auction = random.nextInt(config.getHotAuctionRatio()) > 0 ? AuctionGenerator.lastBase0AuctionId(eventId) / 100L * 100L : AuctionGenerator.nextBase0AuctionId(eventId, random, config);
        long bidder = random.nextInt(config.getHotBiddersRatio()) > 0 ? PersonGenerator.lastBase0PersonId(eventId) / 100L * 100L + 1L : PersonGenerator.nextBase0PersonId(eventId, random, config);
        long price = PriceGenerator.nextPrice(random);
        int currentSize = 32;
        String extra = StringsGenerator.nextExtra(random, currentSize, config.getAvgBidByteSize());
        return new Bid(auction += 1000L, bidder += 1000L, price, timestamp, extra);
    }
}

