/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator.model;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.beam.sdk.nexmark.model.Person;
import org.apache.beam.sdk.nexmark.sources.generator.GeneratorConfig;
import org.apache.beam.sdk.nexmark.sources.generator.model.LongGenerator;
import org.apache.beam.sdk.nexmark.sources.generator.model.StringsGenerator;

public class PersonGenerator {
    private static final int PERSON_ID_LEAD = 10;
    private static final List<String> US_STATES = Arrays.asList("AZ,CA,ID,OR,WA,WY".split(","));
    private static final List<String> US_CITIES = Arrays.asList("Phoenix,Los Angeles,San Francisco,Boise,Portland,Bend,Redmond,Seattle,Kent,Cheyenne".split(","));
    private static final List<String> FIRST_NAMES = Arrays.asList("Peter,Paul,Luke,John,Saul,Vicky,Kate,Julie,Sarah,Deiter,Walter".split(","));
    private static final List<String> LAST_NAMES = Arrays.asList("Shultz,Abrams,Spencer,White,Bartels,Walton,Smith,Jones,Noris".split(","));

    public static Person nextPerson(long nextEventId, Random random, long timestamp, GeneratorConfig config) {
        long id = PersonGenerator.lastBase0PersonId(nextEventId) + 1000L;
        String name = PersonGenerator.nextPersonName(random);
        String email = PersonGenerator.nextEmail(random);
        String creditCard = PersonGenerator.nextCreditCard(random);
        String city = PersonGenerator.nextUSCity(random);
        String state = PersonGenerator.nextUSState(random);
        int currentSize = 8 + name.length() + email.length() + creditCard.length() + city.length() + state.length();
        String extra = StringsGenerator.nextExtra(random, currentSize, config.getAvgPersonByteSize());
        return new Person(id, name, email, creditCard, city, state, timestamp, extra);
    }

    public static long nextBase0PersonId(long eventId, Random random, GeneratorConfig config) {
        long numPeople = PersonGenerator.lastBase0PersonId(eventId) + 1L;
        long activePeople = Math.min(numPeople, (long)config.getNumActivePeople());
        long n = LongGenerator.nextLong(random, activePeople + 10L);
        return numPeople - activePeople + n;
    }

    public static long lastBase0PersonId(long eventId) {
        long epoch = eventId / 50L;
        long offset = eventId % 50L;
        if (offset >= 1L) {
            offset = 0L;
        }
        return epoch * 1L + offset;
    }

    private static String nextUSState(Random random) {
        return US_STATES.get(random.nextInt(US_STATES.size()));
    }

    private static String nextUSCity(Random random) {
        return US_CITIES.get(random.nextInt(US_CITIES.size()));
    }

    private static String nextPersonName(Random random) {
        return FIRST_NAMES.get(random.nextInt(FIRST_NAMES.size())) + " " + LAST_NAMES.get(random.nextInt(LAST_NAMES.size()));
    }

    private static String nextEmail(Random random) {
        return StringsGenerator.nextString(random, 7) + "@" + StringsGenerator.nextString(random, 5) + ".com";
    }

    private static String nextCreditCard(Random random) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(String.format("%04d", random.nextInt(10000)));
        }
        return sb.toString();
    }
}

