/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.nexmark.sources.generator.model;

import java.util.Random;

public class StringsGenerator {
    private static final int MIN_STRING_LENGTH = 3;

    public static String nextString(Random random, int maxLength) {
        int len = 3 + random.nextInt(maxLength - 3);
        StringBuilder sb = new StringBuilder();
        while (len-- > 0) {
            if (random.nextInt(13) == 0) {
                sb.append(' ');
                continue;
            }
            sb.append((char)(97 + random.nextInt(26)));
        }
        return sb.toString().trim();
    }

    public static String nextExactString(Random random, int length) {
        StringBuilder sb = new StringBuilder();
        int rnd = 0;
        int n = 0;
        while (length-- > 0) {
            if (n == 0) {
                rnd = random.nextInt();
                n = 6;
            }
            sb.append((char)(97 + rnd % 26));
            rnd /= 26;
            --n;
        }
        return sb.toString();
    }

    public static String nextExtra(Random random, int currentSize, int desiredAverageSize) {
        if (currentSize > desiredAverageSize) {
            return "";
        }
        int delta = (int)Math.round((double)(desiredAverageSize -= currentSize) * 0.2);
        int minSize = desiredAverageSize - delta;
        int desiredSize = minSize + (delta == 0 ? 0 : random.nextInt(2 * delta));
        return StringsGenerator.nextExactString(random, desiredSize);
    }
}

