/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

public class ScriptException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String fileName = null;
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    protected String message;

    public ScriptException(Exception exception) {
        super(exception);
    }

    public ScriptException(String message) {
        super(message);
        this.message = message;
    }

    public ScriptException(String message, String fileName, int lineNumber) {
        super(message);
        this.message = message;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public ScriptException(String message, String fileName, int lineNumber, int columnNumber) {
        super(message);
        this.message = message;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.message);
        if (this.fileName != null) {
            buffer.append("in: " + this.fileName);
        }
        if (this.lineNumber != -1) {
            buffer.append("at line no: " + this.lineNumber);
        }
        if (this.columnNumber != -1) {
            buffer.append("at column number: " + this.columnNumber);
        }
        return buffer.toString();
    }
}

