/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.MetricsAwareAvaticaHandler;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class AbstractAvaticaHandler
extends AbstractHandler
implements MetricsAwareAvaticaHandler {
    private static final Service.ErrorResponse UNAUTHORIZED_ERROR = new Service.ErrorResponse(Collections.emptyList(), "User is not authenticated", 2, "00002", AvaticaSeverity.ERROR, null);

    public boolean isUserPermitted(AvaticaServerConfiguration serverConfig, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteUser;
        if (null != serverConfig && AuthenticationType.SPNEGO == serverConfig.getAuthenticationType() && null == (remoteUser = request.getRemoteUser())) {
            response.setStatus(401);
            response.getOutputStream().write(UNAUTHORIZED_ERROR.serialize().toByteArray());
            return false;
        }
        return true;
    }
}

