/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.util.Arrays;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaJsonHandler;
import org.apache.calcite.avatica.server.HttpServer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class Main {
    private static final HandlerFactory JSON_HANDLER_FACTORY = new HandlerFactory(){

        @Override
        public AbstractHandler createHandler(Service service) {
            return new AvaticaJsonHandler(service);
        }
    };

    private Main() {
    }

    public static void main(String[] args) throws InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        HttpServer server = Main.start(args);
        server.join();
    }

    public static HttpServer start(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Main.start(args, 8765, JSON_HANDLER_FACTORY);
    }

    public static HttpServer start(String[] args, int port, HandlerFactory handlerFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String factoryClassName = args[0];
        Class<?> factoryClass = Class.forName(factoryClassName);
        Meta.Factory factory = (Meta.Factory)factoryClass.newInstance();
        Meta meta = factory.create(Arrays.asList(args).subList(1, args.length));
        LocalService service = new LocalService(meta);
        HttpServer server = new HttpServer(port, (Handler)handlerFactory.createHandler((Service)service));
        server.start();
        return server;
    }

    public static interface HandlerFactory {
        public AbstractHandler createHandler(Service var1);
    }
}

