/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.calcite.adapter.druid.DruidConnection;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidType;
import org.apache.calcite.adapter.druid.QueryType;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.runtime.HttpUtils;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Util;
import org.joda.time.Interval;

class DruidConnectionImpl
implements DruidConnection {
    private final String url;
    private final String coordinatorUrl;
    public static final String DEFAULT_RESPONSE_TIMESTAMP_COLUMN = "timestamp";
    private static final SimpleDateFormat UTC_TIMESTAMP_FORMAT = DateTimeStringUtils.getDateFormatter((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final SimpleDateFormat TIMESTAMP_FORMAT = DateTimeStringUtils.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss");

    DruidConnectionImpl(String url, String coordinatorUrl) {
        this.url = Objects.requireNonNull(url);
        this.coordinatorUrl = Objects.requireNonNull(coordinatorUrl);
    }

    public void request(QueryType queryType, String data, Sink sink, List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, Page page) {
        String url = this.url + "/druid/v2/?pretty";
        ImmutableMap requestHeaders = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println(data);
        }
        try (InputStream in0 = HttpUtils.post((String)url, (CharSequence)data, (Map)requestHeaders, (int)10000, (int)1800000);
             InputStream in = this.traceResponse(in0);){
            this.parse(queryType, in, sink, fieldNames, fieldTypes, page);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while processing druid request [" + data + "]", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parse(QueryType queryType, InputStream in, Sink sink, List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, Page page) {
        factory = new JsonFactory();
        rowBuilder = Row.newBuilder((int)fieldNames.size());
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            try {
                bytes = AvaticaUtils.readFullyToBytes((InputStream)in);
                System.out.println("Response: " + new String(bytes, StandardCharsets.UTF_8));
                in = new ByteArrayInputStream(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        posTimestampField = -1;
        for (i = 0; i < fieldTypes.size(); ++i) {
            if (fieldTypes.get(i) != ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP) continue;
            posTimestampField = i;
            break;
        }
        try {
            parser = factory.createParser(in);
            var11_15 = null;
            try {
                switch (2.$SwitchMap$org$apache$calcite$adapter$druid$QueryType[queryType.ordinal()]) {
                    case 1: {
                        if (parser.nextToken() != JsonToken.START_ARRAY) ** break;
                        while (parser.nextToken() == JsonToken.START_OBJECT) {
                            timeValue = this.extractTimestampField(parser);
                            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("result") && parser.nextToken() == JsonToken.START_OBJECT) {
                                if (posTimestampField != -1) {
                                    rowBuilder.set(posTimestampField, timeValue);
                                }
                                this.parseFields(fieldNames, fieldTypes, rowBuilder, parser);
                                sink.send(rowBuilder.build());
                                rowBuilder.reset();
                            }
                            this.expect(parser, JsonToken.END_OBJECT);
                        }
                        break;
                    }
                    case 2: {
                        if (parser.nextToken() == JsonToken.START_ARRAY && parser.nextToken() == JsonToken.START_OBJECT) {
                            timeValue = this.extractTimestampField(parser);
                            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("result") && parser.nextToken() == JsonToken.START_ARRAY) {
                                while (parser.nextToken() == JsonToken.START_OBJECT) {
                                    if (posTimestampField != -1) {
                                        rowBuilder.set(posTimestampField, timeValue);
                                    }
                                    this.parseFields(fieldNames, fieldTypes, rowBuilder, parser);
                                    sink.send(rowBuilder.build());
                                    rowBuilder.reset();
                                }
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (parser.nextToken() == JsonToken.START_ARRAY && parser.nextToken() == JsonToken.START_OBJECT) {
                            page.pagingIdentifier = null;
                            page.offset = -1;
                            page.totalRowCount = 0;
                            this.expectScalarField(parser, "timestamp");
                            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("result") && parser.nextToken() == JsonToken.START_OBJECT) {
                                while (parser.nextToken() == JsonToken.FIELD_NAME) {
                                    if (parser.getCurrentName().equals("pagingIdentifiers") && parser.nextToken() == JsonToken.START_OBJECT) {
                                        token = parser.nextToken();
                                        while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                                            page.pagingIdentifier = parser.getCurrentName();
                                            if (parser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                                                page.offset = parser.getIntValue();
                                            }
                                            token = parser.nextToken();
                                        }
                                        this.expect(token, JsonToken.END_OBJECT);
                                        continue;
                                    }
                                    if (parser.getCurrentName().equals("events") && parser.nextToken() == JsonToken.START_ARRAY) {
                                        while (parser.nextToken() == JsonToken.START_OBJECT) {
                                            this.expectScalarField(parser, "segmentId");
                                            this.expectScalarField(parser, "offset");
                                            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("event") && parser.nextToken() == JsonToken.START_OBJECT) {
                                                this.parseFields(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser);
                                                sink.send(rowBuilder.build());
                                                rowBuilder.reset();
                                                ++page.totalRowCount;
                                            }
                                            this.expect(parser, JsonToken.END_OBJECT);
                                        }
                                        parser.nextToken();
                                        continue;
                                    }
                                    if (!parser.getCurrentName().equals("dimensions") && !parser.getCurrentName().equals("metrics")) continue;
                                    this.expect(parser, JsonToken.START_ARRAY);
                                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (parser.nextToken() != JsonToken.START_ARRAY) ** break;
                        while (parser.nextToken() == JsonToken.START_OBJECT) {
                            this.expectScalarField(parser, "version");
                            timeValue = this.extractTimestampField(parser);
                            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("event") && parser.nextToken() == JsonToken.START_OBJECT) {
                                if (posTimestampField != -1) {
                                    rowBuilder.set(posTimestampField, timeValue);
                                }
                                this.parseFields(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser);
                                sink.send(rowBuilder.build());
                                rowBuilder.reset();
                            }
                            this.expect(parser, JsonToken.END_OBJECT);
                        }
                        break;
                    }
                    case 5: {
                        if (parser.nextToken() != JsonToken.START_ARRAY) ** break;
                        while (parser.nextToken() == JsonToken.START_OBJECT) {
                            this.expectScalarField(parser, "segmentId");
                            this.expect(parser, JsonToken.FIELD_NAME);
                            if (parser.getCurrentName().equals("columns")) {
                                this.expect(parser, JsonToken.START_ARRAY);
                                while (parser.nextToken() != JsonToken.END_ARRAY) {
                                }
                            }
                            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("events") && parser.nextToken() == JsonToken.START_ARRAY) {
                                while (parser.nextToken() == JsonToken.START_ARRAY) {
                                    for (String field : fieldNames) {
                                        this.parseFieldForName(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser, field);
                                    }
                                    this.expect(parser, JsonToken.END_ARRAY);
                                    row = rowBuilder.build();
                                    sink.send(row);
                                    rowBuilder.reset();
                                    ++page.totalRowCount;
                                }
                            }
                            this.expect(parser, JsonToken.END_OBJECT);
                        }
                        break;
                    }
                    ** default:
lbl122:
                    // 1 sources

                    break;
                }
            }
            catch (Throwable var12_18) {
                var11_15 = var12_18;
                throw var12_18;
            }
            finally {
                if (parser != null) {
                    if (var11_15 != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable var12_17) {
                            var11_15.addSuppressed(var12_17);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseFields(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, Row.RowBuilder rowBuilder, JsonParser parser) throws IOException {
        this.parseFields(fieldNames, fieldTypes, -1, rowBuilder, parser);
    }

    private void parseFields(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, int posTimestampField, Row.RowBuilder rowBuilder, JsonParser parser) throws IOException {
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            this.parseField(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser);
        }
    }

    private void parseField(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, int posTimestampField, Row.RowBuilder rowBuilder, JsonParser parser) throws IOException {
        String fieldName = parser.getCurrentName();
        this.parseFieldForName(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFieldForName(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, int posTimestampField, Row.RowBuilder rowBuilder, JsonParser parser, String fieldName) throws IOException {
        JsonToken token = parser.nextToken();
        boolean isTimestampColumn = fieldName.equals(DEFAULT_RESPONSE_TIMESTAMP_COLUMN);
        int i = fieldNames.indexOf(fieldName);
        ColumnMetaData.Rep type = null;
        if (i < 0) {
            if (!isTimestampColumn) {
                return;
            }
        } else {
            type = fieldTypes.get(i);
        }
        if (isTimestampColumn || ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP == type) {
            int fieldPos;
            int n = fieldPos = posTimestampField != -1 ? posTimestampField : i;
            if (token == JsonToken.VALUE_NUMBER_INT) {
                rowBuilder.set(posTimestampField, (Object)parser.getLongValue());
                return;
            }
            SimpleDateFormat simpleDateFormat = UTC_TIMESTAMP_FORMAT;
            synchronized (simpleDateFormat) {
                try {
                    rowBuilder.set(fieldPos, (Object)UTC_TIMESTAMP_FORMAT.parse(parser.getText()).getTime());
                }
                catch (ParseException e) {
                    try {
                        rowBuilder.set(fieldPos, (Object)TIMESTAMP_FORMAT.parse(parser.getText()).getTime());
                    }
                    catch (ParseException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            return;
        }
        switch (token) {
            case VALUE_NUMBER_INT: {
                if (type == null) {
                    type = ColumnMetaData.Rep.LONG;
                }
            }
            case VALUE_NUMBER_FLOAT: {
                if (type == null) {
                    type = ColumnMetaData.Rep.DOUBLE;
                }
                switch (type) {
                    case BYTE: {
                        rowBuilder.set(i, (Object)parser.getByteValue());
                        break;
                    }
                    case SHORT: {
                        rowBuilder.set(i, (Object)parser.getShortValue());
                        break;
                    }
                    case INTEGER: {
                        rowBuilder.set(i, (Object)parser.getIntValue());
                        break;
                    }
                    case LONG: {
                        rowBuilder.set(i, (Object)parser.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        rowBuilder.set(i, (Object)parser.getDoubleValue());
                    }
                }
                break;
            }
            case VALUE_TRUE: {
                rowBuilder.set(i, (Object)true);
                break;
            }
            case VALUE_FALSE: {
                rowBuilder.set(i, (Object)false);
                break;
            }
            case VALUE_NULL: {
                break;
            }
            default: {
                String s = parser.getText();
                if (type != null) {
                    switch (type) {
                        case SHORT: 
                        case INTEGER: 
                        case LONG: 
                        case PRIMITIVE_LONG: 
                        case PRIMITIVE_SHORT: 
                        case PRIMITIVE_INT: {
                            switch (s) {
                                case "Infinity": 
                                case "-Infinity": 
                                case "NaN": {
                                    throw new RuntimeException("/ by zero");
                                }
                            }
                            rowBuilder.set(i, (Object)Long.valueOf(s));
                            break;
                        }
                        case DOUBLE: 
                        case FLOAT: 
                        case PRIMITIVE_FLOAT: 
                        case PRIMITIVE_DOUBLE: 
                        case NUMBER: {
                            switch (s) {
                                case "Infinity": {
                                    rowBuilder.set(i, (Object)Double.POSITIVE_INFINITY);
                                    return;
                                }
                                case "-Infinity": {
                                    rowBuilder.set(i, (Object)Double.NEGATIVE_INFINITY);
                                    return;
                                }
                                case "NaN": {
                                    rowBuilder.set(i, (Object)Double.NaN);
                                    return;
                                }
                            }
                            rowBuilder.set(i, (Object)Double.valueOf(s));
                        }
                    }
                    break;
                }
                rowBuilder.set(i, (Object)s);
            }
        }
    }

    private void expect(JsonParser parser, JsonToken token) throws IOException {
        this.expect(parser.nextToken(), token);
    }

    private void expect(JsonToken token, JsonToken expected) throws IOException {
        if (token != expected) {
            throw new RuntimeException("expected " + expected + ", got " + token);
        }
    }

    private void expectScalarField(JsonParser parser, String name) throws IOException {
        this.expect(parser, JsonToken.FIELD_NAME);
        if (!parser.getCurrentName().equals(name)) {
            throw new RuntimeException("expected field " + name + ", got " + parser.getCurrentName());
        }
        JsonToken t = parser.nextToken();
        switch (t) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: 
            case VALUE_STRING: {
                break;
            }
            default: {
                throw new RuntimeException("expected scalar field, got  " + t);
            }
        }
    }

    private void expectObjectField(JsonParser parser, String name) throws IOException {
        this.expect(parser, JsonToken.FIELD_NAME);
        if (!parser.getCurrentName().equals(name)) {
            throw new RuntimeException("expected field " + name + ", got " + parser.getCurrentName());
        }
        this.expect(parser, JsonToken.START_OBJECT);
        while (parser.nextToken() != JsonToken.END_OBJECT) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long extractTimestampField(JsonParser parser) throws IOException {
        this.expect(parser, JsonToken.FIELD_NAME);
        if (!parser.getCurrentName().equals(DEFAULT_RESPONSE_TIMESTAMP_COLUMN)) {
            throw new RuntimeException("expected field timestamp, got " + parser.getCurrentName());
        }
        parser.nextToken();
        try {
            Date parse;
            SimpleDateFormat simpleDateFormat = UTC_TIMESTAMP_FORMAT;
            synchronized (simpleDateFormat) {
                parse = UTC_TIMESTAMP_FORMAT.parse(parser.getText());
            }
            return parse.getTime();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Enumerable<Row> enumerable(final QueryType queryType, final String request, final List<String> fieldNames, final ExecutorService service) throws IOException {
        return new AbstractEnumerable<Row>(){

            public Enumerator<Row> enumerator() {
                final BlockingQueueEnumerator<Row> enumerator = new BlockingQueueEnumerator<Row>();
                RunnableQueueSink sink = new RunnableQueueSink(){

                    public void send(Row row) throws InterruptedException {
                        enumerator.queue.put(row);
                    }

                    public void end() {
                        enumerator.done.set(true);
                    }

                    public void setSourceEnumerable(Enumerable<Row> enumerable) throws InterruptedException {
                        for (Row row : enumerable) {
                            this.send(row);
                        }
                        this.end();
                    }

                    @Override
                    public void run() {
                        try {
                            Page page = new Page();
                            List<Object> fieldTypes = Collections.nCopies(fieldNames.size(), null);
                            DruidConnectionImpl.this.request(queryType, request, this, fieldNames, fieldTypes, page);
                            enumerator.done.set(true);
                        }
                        catch (Throwable e) {
                            enumerator.throwableHolder.set((Object)e);
                            enumerator.done.set(true);
                        }
                    }
                };
                service.execute(sink);
                return enumerator;
            }
        };
    }

    void metadata(String dataSourceName, String timestampColumnName, List<Interval> intervals, Map<String, SqlTypeName> fieldBuilder, Set<String> metricNameBuilder, Map<String, List<ComplexMetric>> complexMetrics) {
        String url = this.url + "/druid/v2/?pretty";
        ImmutableMap requestHeaders = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");
        String data = DruidQuery.metadataQuery(dataSourceName, intervals);
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println("Druid: " + data);
        }
        try (InputStream in0 = HttpUtils.post((String)url, (CharSequence)data, (Map)requestHeaders, (int)10000, (int)1800000);
             InputStream in = this.traceResponse(in0);){
            ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CollectionType listType = mapper.getTypeFactory().constructCollectionType(List.class, JsonSegmentMetadata.class);
            List list = (List)mapper.readValue(in, (JavaType)listType);
            in.close();
            fieldBuilder.put(timestampColumnName, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
            for (JsonSegmentMetadata o : list) {
                for (Map.Entry<String, JsonColumn> entry : o.columns.entrySet()) {
                    DruidType druidType;
                    if (entry.getKey().equals("__time")) continue;
                    try {
                        druidType = DruidType.getTypeFromMetaData(entry.getValue().type);
                    }
                    catch (AssertionError e) {
                        continue;
                    }
                    fieldBuilder.put(entry.getKey(), druidType.sqlType);
                }
                if (o.aggregators == null) continue;
                for (Map.Entry<String, Object> entry : o.aggregators.entrySet()) {
                    if (!fieldBuilder.containsKey(entry.getKey())) continue;
                    DruidType type = DruidType.getTypeFromMetaData(((JsonAggregator)entry.getValue()).type);
                    if (type.isComplex()) {
                        ArrayList<ComplexMetric> metricList = new ArrayList<ComplexMetric>();
                        metricList.add(new ComplexMetric(entry.getKey(), type));
                        complexMetrics.put(entry.getKey(), metricList);
                        continue;
                    }
                    metricNameBuilder.add(entry.getKey());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    Set<String> tableNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream traceResponse(InputStream in) {
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            try {
                byte[] bytes = AvaticaUtils.readFullyToBytes((InputStream)in);
                in.close();
                System.out.println("Response: " + new String(bytes, StandardCharsets.UTF_8));
                in = new ByteArrayInputStream(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return in;
    }

    private static class JsonAggregator {
        public String type;
        public String name;
        public String fieldName;

        private JsonAggregator() {
        }

        DruidType druidType() {
            return DruidType.getTypeFromMetric(this.type);
        }
    }

    private static class JsonColumn {
        public String type;
        public boolean hasMultipleValues;
        public int size;
        public Integer cardinality;
        public String errorMessage;

        private JsonColumn() {
        }
    }

    private static class JsonSegmentMetadata {
        public String id;
        public List<String> intervals;
        public Map<String, JsonColumn> columns;
        public long size;
        public long numRows;
        public Map<String, JsonAggregator> aggregators;

        private JsonSegmentMetadata() {
        }
    }

    static class Page {
        String pagingIdentifier = null;
        int offset = -1;
        int totalRowCount = 0;

        Page() {
        }

        public String toString() {
            return "{" + this.pagingIdentifier + ": " + this.offset + "}";
        }
    }

    private static class BlockingQueueEnumerator<E>
    implements Enumerator<E> {
        final BlockingQueue<E> queue = new ArrayBlockingQueue(1000);
        final AtomicBoolean done = new AtomicBoolean(false);
        final Holder<Throwable> throwableHolder = Holder.of(null);
        E next;

        private BlockingQueueEnumerator() {
        }

        public E current() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        public boolean moveNext() {
            do {
                this.next = this.queue.poll();
                if (this.next == null) continue;
                return true;
            } while (!this.done.get());
            this.close();
            return false;
        }

        public void reset() {
        }

        public void close() {
            Throwable e = (Throwable)this.throwableHolder.get();
            if (e != null) {
                this.throwableHolder.set(null);
                Util.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static interface RunnableQueueSink
    extends Sink,
    Runnable {
    }
}

