/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidJsonFilter;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.QueryType;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.rules.AggregateExtractProjectRule;
import org.apache.calcite.rel.rules.AggregateFilterTransposeRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectSortTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.joda.time.Interval;
import org.slf4j.Logger;

public class DruidRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    public static final DruidFilterRule FILTER = new DruidFilterRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectRule PROJECT = new DruidProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateRule AGGREGATE = new DruidAggregateRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateProjectRule AGGREGATE_PROJECT = new DruidAggregateProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidSortRule SORT = new DruidSortRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidSortProjectTransposeRule SORT_PROJECT_TRANSPOSE = new DruidSortProjectTransposeRule(RelFactories.LOGICAL_BUILDER);
    @Deprecated
    public static final DruidProjectSortTransposeRule PROJECT_SORT_TRANSPOSE = new DruidProjectSortTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidProjectFilterTransposeRule PROJECT_FILTER_TRANSPOSE = new DruidProjectFilterTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidFilterProjectTransposeRule FILTER_PROJECT_TRANSPOSE = new DruidFilterProjectTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateFilterTransposeRule AGGREGATE_FILTER_TRANSPOSE = new DruidAggregateFilterTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidFilterAggregateTransposeRule FILTER_AGGREGATE_TRANSPOSE = new DruidFilterAggregateTransposeRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidPostAggregationProjectRule POST_AGGREGATION_PROJECT = new DruidPostAggregationProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidAggregateExtractProjectRule PROJECT_EXTRACT_RULE = new DruidAggregateExtractProjectRule(RelFactories.LOGICAL_BUILDER);
    public static final DruidHavingFilterRule DRUID_HAVING_FILTER_RULE = new DruidHavingFilterRule(RelFactories.LOGICAL_BUILDER);
    public static final List<RelOptRule> RULES = ImmutableList.of((Object)((Object)FILTER), (Object)((Object)PROJECT_FILTER_TRANSPOSE), (Object)((Object)AGGREGATE_FILTER_TRANSPOSE), (Object)((Object)AGGREGATE_PROJECT), (Object)((Object)PROJECT_EXTRACT_RULE), (Object)((Object)PROJECT), (Object)((Object)POST_AGGREGATION_PROJECT), (Object)((Object)AGGREGATE), (Object)((Object)FILTER_AGGREGATE_TRANSPOSE), (Object)((Object)FILTER_PROJECT_TRANSPOSE), (Object)((Object)SORT), (Object)((Object)SORT_PROJECT_TRANSPOSE), (Object[])new RelOptRule[]{DRUID_HAVING_FILTER_RULE});

    private DruidRules() {
    }

    public static class DruidAggregateExtractProjectRule
    extends AggregateExtractProjectRule {
        public DruidAggregateExtractProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateExtractProjectRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateExtractProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateExtractProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidFilterAggregateTransposeRule
    extends FilterAggregateTransposeRule {
        public DruidFilterAggregateTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterAggregateTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterAggregateTransposeRule.operand(Aggregate.class, (RelOptRuleOperand)DruidFilterAggregateTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterAggregateTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidAggregateFilterTransposeRule
    extends AggregateFilterTransposeRule {
        public DruidAggregateFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateFilterTransposeRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateFilterTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidAggregateFilterTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateFilterTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory);
        }
    }

    public static class DruidFilterProjectTransposeRule
    extends FilterProjectTransposeRule {
        public DruidFilterProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterProjectTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidFilterProjectTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterProjectTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), true, true, relBuilderFactory);
        }
    }

    public static class DruidProjectFilterTransposeRule
    extends ProjectFilterTransposeRule {
        public DruidProjectFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectFilterTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidProjectFilterTransposeRule.operand(Filter.class, (RelOptRuleOperand)DruidProjectFilterTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectFilterTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), expr -> false, false, false, relBuilderFactory);
        }
    }

    public static class DruidSortRule
    extends RelOptRule {
        public DruidSortRule(RelBuilderFactory relBuilderFactory) {
            super(DruidSortRule.operand(Sort.class, (RelOptRuleOperand)DruidSortRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidSortRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'l')) {
                return;
            }
            if (sort.offset != null && RexLiteral.intValue((RexNode)sort.offset) != 0) {
                return;
            }
            if (query.getQueryType() == QueryType.SCAN && !RelOptUtil.isPureLimit((RelNode)sort)) {
                return;
            }
            Sort newSort = sort.copy(sort.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            call.transformTo((RelNode)DruidQuery.extendQuery(query, (RelNode)newSort));
        }
    }

    @Deprecated
    public static class DruidProjectSortTransposeRule
    extends ProjectSortTransposeRule {
        public DruidProjectSortTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectSortTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidProjectSortTransposeRule.operand(Sort.class, (RelOptRuleOperand)DruidProjectSortTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectSortTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }
    }

    public static class DruidSortProjectTransposeRule
    extends SortProjectTransposeRule {
        public DruidSortProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DruidSortProjectTransposeRule.operand(Sort.class, (RelOptRuleOperand)DruidSortProjectTransposeRule.operand(Project.class, (RelOptRuleOperand)DruidSortProjectTransposeRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidSortProjectTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }
    }

    public static class DruidAggregateProjectRule
    extends RelOptRule {
        public DruidAggregateProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateProjectRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateProjectRule.operand(Project.class, (RelOptRuleOperand)DruidAggregateProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            DruidQuery query2;
            Aggregate aggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            DruidQuery query = (DruidQuery)call.rel(2);
            if (!DruidQuery.isValidSignature(query.signature() + 'p' + 'a')) {
                return;
            }
            if (aggregate.getGroupSets().size() != 1) {
                return;
            }
            if (DruidQuery.computeProjectGroupSet(project, aggregate.getGroupSet(), query.table.getRowType(), query) == null) {
                return;
            }
            List aggNames = Util.skip((List)aggregate.getRowType().getFieldNames(), (int)aggregate.getGroupSet().cardinality());
            if (DruidQuery.computeDruidJsonAgg(aggregate.getAggCallList(), aggNames, project, query) == null) {
                return;
            }
            RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), (List)ImmutableList.of((Object)newProject));
            List<Integer> filterRefs = DruidAggregateProjectRule.getFilterRefs(aggregate.getAggCallList());
            if (filterRefs.size() > 0) {
                query2 = this.optimizeFilteredAggregations(call, query, (Project)newProject, (Aggregate)newAggregate);
            } else {
                DruidQuery query1 = DruidQuery.extendQuery(query, newProject);
                query2 = DruidQuery.extendQuery(query1, newAggregate);
            }
            call.transformTo((RelNode)query2);
        }

        private Set<Integer> getUniqueFilterRefs(List<AggregateCall> calls) {
            HashSet<Integer> refs = new HashSet<Integer>();
            for (AggregateCall call : calls) {
                if (!call.hasFilter()) continue;
                refs.add(call.filterArg);
            }
            return refs;
        }

        private DruidQuery optimizeFilteredAggregations(RelOptRuleCall call, DruidQuery query, Project project, Aggregate aggregate) {
            Filter filter = null;
            RexBuilder builder = query.getCluster().getRexBuilder();
            RexExecutor executor = (RexExecutor)Util.first((Object)query.getCluster().getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
            RelNode scan = (RelNode)query.rels.get(0);
            RelOptPredicateList predicates = call.getMetadataQuery().getPulledUpPredicates(scan);
            RexSimplify simplify = new RexSimplify(builder, predicates, executor);
            boolean containsFilter = false;
            for (RelNode node : query.rels) {
                if (!(node instanceof Filter)) continue;
                filter = (Filter)node;
                containsFilter = true;
                break;
            }
            boolean allHaveFilters = DruidAggregateProjectRule.allAggregatesHaveFilters(aggregate.getAggCallList());
            Set<Integer> uniqueFilterRefs = this.getUniqueFilterRefs(aggregate.getAggCallList());
            assert (uniqueFilterRefs.size() > 0);
            ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>();
            ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
            for (Object i : uniqueFilterRefs) {
                disjunctions.add(DruidAggregateProjectRule.stripFilter((RexNode)project.getProjects().get((Integer)i)));
            }
            RexNode filterNode = RexUtil.composeDisjunction((RexBuilder)builder, disjunctions);
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                if (uniqueFilterRefs.size() == 1 && allHaveFilters || aggCall.hasFilter() && ((RexNode)project.getProjects().get(aggCall.filterArg)).isAlwaysTrue()) {
                    aggCall = aggCall.copy(aggCall.getArgList(), -1, aggCall.collation);
                }
                newCalls.add(aggCall);
            }
            aggregate = aggregate.copy(aggregate.getTraitSet(), aggregate.getInput(), aggregate.getGroupSet(), (List)aggregate.getGroupSets(), newCalls);
            if (containsFilter) {
                filterNode = builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{filterNode, filter.getCondition()});
            }
            RexNode tempFilterNode = filterNode;
            if ((filterNode = simplify.simplifyUnknownAsFalse(filterNode)).isAlwaysFalse()) {
                filterNode = tempFilterNode;
            }
            boolean addNewFilter = !(filter = LogicalFilter.create((RelNode)scan, (RexNode)filterNode)).getCondition().isAlwaysTrue() && allHaveFilters;
            int startIndex = containsFilter && addNewFilter ? 2 : 1;
            List<RelNode> newNodes = DruidAggregateProjectRule.constructNewNodes(query.rels, addNewFilter, startIndex, (RelNode)filter, new RelNode[]{project, aggregate});
            return DruidQuery.create(query.getCluster(), aggregate.getTraitSet().replace((RelTrait)query.getConvention()), query.getTable(), query.druidTable, newNodes);
        }

        private static boolean allAggregatesHaveFilters(List<AggregateCall> calls) {
            for (AggregateCall call : calls) {
                if (call.hasFilter()) continue;
                return false;
            }
            return true;
        }

        private static List<RelNode> constructNewNodes(List<RelNode> oldNodes, boolean addFilter, int startIndex, RelNode filter, RelNode ... trailingNodes) {
            ArrayList<RelNode> newNodes = new ArrayList<RelNode>();
            newNodes.add(oldNodes.get(0));
            if (addFilter) {
                newNodes.add(filter);
                if (startIndex < oldNodes.size()) {
                    RelNode next = oldNodes.get(startIndex);
                    newNodes.add(next.copy(next.getTraitSet(), Collections.singletonList(filter)));
                    ++startIndex;
                }
            }
            for (int i = startIndex; i < oldNodes.size(); ++i) {
                newNodes.add(oldNodes.get(i));
            }
            for (RelNode node : trailingNodes) {
                newNodes.add(node.copy(node.getTraitSet(), Collections.singletonList(Util.last(newNodes))));
            }
            return newNodes;
        }

        private static RexNode stripFilter(RexNode node) {
            if (node.getKind() == SqlKind.IS_TRUE) {
                return (RexNode)((RexCall)node).getOperands().get(0);
            }
            return node;
        }

        private static List<Integer> getFilterRefs(List<AggregateCall> calls) {
            ArrayList<Integer> refs = new ArrayList<Integer>();
            for (AggregateCall call : calls) {
                if (!call.hasFilter()) continue;
                refs.add(call.filterArg);
            }
            return refs;
        }
    }

    public static class DruidAggregateRule
    extends RelOptRule {
        public DruidAggregateRule(RelBuilderFactory relBuilderFactory) {
            super(DruidAggregateRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Project project;
            Aggregate aggregate = (Aggregate)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelNode topDruidNode = query.getTopNode();
            Project project2 = project = topDruidNode instanceof Project ? (Project)topDruidNode : null;
            if (!DruidQuery.isValidSignature(query.signature() + 'a')) {
                return;
            }
            if (aggregate.getGroupSets().size() != 1) {
                return;
            }
            if (DruidQuery.computeProjectGroupSet(project, aggregate.getGroupSet(), query.table.getRowType(), query) == null) {
                return;
            }
            List aggNames = Util.skip((List)aggregate.getRowType().getFieldNames(), (int)aggregate.getGroupSet().cardinality());
            if (DruidQuery.computeDruidJsonAgg(aggregate.getAggCallList(), aggNames, project, query) == null) {
                return;
            }
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), (List)ImmutableList.of((Object)query.getTopNode()));
            call.transformTo((RelNode)DruidQuery.extendQuery(query, newAggregate));
        }
    }

    public static class DruidPostAggregationProjectRule
    extends RelOptRule {
        public DruidPostAggregationProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidPostAggregationProjectRule.operand(Project.class, (RelOptRuleOperand)DruidPostAggregationProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidPostAggregationProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'o')) {
                return;
            }
            boolean hasRexCalls = false;
            for (RexNode rexNode : project.getProjects()) {
                if (!(rexNode instanceof RexCall)) continue;
                hasRexCalls = true;
                break;
            }
            if (hasRexCalls) {
                RelNode topNode = query.getTopNode();
                Aggregate topAgg = topNode instanceof Aggregate ? (Aggregate)topNode : (Aggregate)((Filter)topNode).getInput();
                for (RexNode rexNode : project.getProjects()) {
                    if (DruidExpressions.toDruidExpression(rexNode, topAgg.getRowType(), query) != null) continue;
                    return;
                }
                RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
                DruidQuery newQuery = DruidQuery.extendQuery(query, newProject);
                call.transformTo((RelNode)newQuery);
            }
        }
    }

    public static class DruidProjectRule
    extends RelOptRule {
        public DruidProjectRule(RelBuilderFactory relBuilderFactory) {
            super(DruidProjectRule.operand(Project.class, (RelOptRuleOperand)DruidProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = project.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'p')) {
                return;
            }
            if (DruidQuery.computeProjectAsScan(project, query.getTable().getRowType(), query) != null) {
                RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
                DruidQuery newNode = DruidQuery.extendQuery(query, newProject);
                call.transformTo((RelNode)newNode);
                return;
            }
            Pair<List<RexNode>, List<RexNode>> pair = DruidProjectRule.splitProjects(rexBuilder, (RelNode)query, project.getProjects());
            if (pair == null) {
                return;
            }
            List above = (List)pair.left;
            List below = (List)pair.right;
            RelDataTypeFactory.FieldInfoBuilder builder = cluster.getTypeFactory().builder();
            RelNode input = (RelNode)Util.last(query.rels);
            for (RexNode e : below) {
                String name = e instanceof RexInputRef ? (String)input.getRowType().getFieldNames().get(((RexInputRef)e).getIndex()) : null;
                builder.add(name, e.getType());
            }
            Project newProject = project.copy(project.getTraitSet(), input, below, builder.build());
            DruidQuery newQuery = DruidQuery.extendQuery(query, (RelNode)newProject);
            Project newProject2 = project.copy(project.getTraitSet(), (RelNode)newQuery, above, project.getRowType());
            call.transformTo((RelNode)newProject2);
        }

        private static Pair<List<RexNode>, List<RexNode>> splitProjects(final RexBuilder rexBuilder, RelNode input, List<RexNode> nodes) {
            RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
            visitor.visitEach(nodes);
            if (visitor.inputPosReferenced.size() == input.getRowType().getFieldCount()) {
                return null;
            }
            ArrayList<RexInputRef> belowNodes = new ArrayList<RexInputRef>();
            final ArrayList<RelDataType> belowTypes = new ArrayList<RelDataType>();
            final ArrayList positions = Lists.newArrayList((Iterable)visitor.inputPosReferenced);
            Iterator iterator = positions.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                RexInputRef node = rexBuilder.makeInputRef(input, i);
                belowNodes.add(node);
                belowTypes.add(node.getType());
            }
            List aboveNodes = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    int index = positions.indexOf(ref.getIndex());
                    return rexBuilder.makeInputRef((RelDataType)belowTypes.get(index), index);
                }
            }.visitList(nodes);
            return Pair.of((Object)aboveNodes, belowNodes);
        }
    }

    public static class DruidHavingFilterRule
    extends RelOptRule {
        public DruidHavingFilterRule(RelBuilderFactory relBuilderFactory) {
            super(DruidHavingFilterRule.operand(Filter.class, (RelOptRuleOperand)DruidHavingFilterRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidHavingFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'h')) {
                return;
            }
            RexNode cond = filter.getCondition();
            DruidJsonFilter druidJsonFilter = DruidJsonFilter.toDruidFilters(cond, query.getTopNode().getRowType(), query);
            if (druidJsonFilter != null) {
                Filter newFilter = filter.copy(filter.getTraitSet(), (RelNode)Util.last(query.rels), filter.getCondition());
                DruidQuery newDruidQuery = DruidQuery.extendQuery(query, (RelNode)newFilter);
                call.transformTo((RelNode)newDruidQuery);
            }
        }
    }

    public static class DruidFilterRule
    extends RelOptRule {
        public DruidFilterRule(RelBuilderFactory relBuilderFactory) {
            super(DruidFilterRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = filter.getCluster();
            RelBuilder relBuilder = call.builder();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'f')) {
                return;
            }
            ArrayList<RexNode> validPreds = new ArrayList<RexNode>();
            ArrayList<RexNode> nonValidPreds = new ArrayList<RexNode>();
            RexExecutor executor = (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
            RelOptPredicateList predicates = call.getMetadataQuery().getPulledUpPredicates(filter.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, executor);
            RexNode cond = simplify.simplifyUnknownAsFalse(filter.getCondition());
            for (RexNode e : RelOptUtil.conjunctions((RexNode)cond)) {
                DruidJsonFilter druidJsonFilter = DruidJsonFilter.toDruidFilters(e, filter.getInput().getRowType(), query);
                if (druidJsonFilter != null) {
                    validPreds.add(e);
                    continue;
                }
                nonValidPreds.add(e);
            }
            int timestampFieldIdx = query.getRowType().getFieldNames().indexOf(query.druidTable.timestampFieldName);
            DruidQuery newDruidQuery = query;
            Triple<List<RexNode>, List<RexNode>, List<RexNode>> triple = DruidFilterRule.splitFilters(rexBuilder, query, validPreds, nonValidPreds, timestampFieldIdx);
            if (((List)triple.getLeft()).isEmpty() && ((List)triple.getMiddle()).isEmpty()) {
                return;
            }
            ArrayList residualPreds = new ArrayList((Collection)triple.getRight());
            List<Interval> intervals = null;
            if (!((List)triple.getLeft()).isEmpty()) {
                String timeZone = ((CalciteConnectionConfig)cluster.getPlanner().getContext().unwrap(CalciteConnectionConfig.class)).timeZone();
                assert (timeZone != null);
                intervals = DruidDateTimeUtils.createInterval(RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)triple.getLeft())));
                if (intervals == null || intervals.isEmpty()) {
                    ((List)triple.getMiddle()).addAll((Collection)triple.getLeft());
                }
            }
            if (!((List)triple.getMiddle()).isEmpty()) {
                Filter newFilter = filter.copy(filter.getTraitSet(), (RelNode)Util.last(query.rels), RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)triple.getMiddle())));
                newDruidQuery = DruidQuery.extendQuery(query, (RelNode)newFilter);
            }
            if (intervals != null && !intervals.isEmpty()) {
                newDruidQuery = DruidQuery.extendQuery(newDruidQuery, intervals);
            }
            if (!residualPreds.isEmpty()) {
                newDruidQuery = relBuilder.push((RelNode)newDruidQuery).filter(residualPreds).build();
            }
            call.transformTo((RelNode)newDruidQuery);
        }

        private static Triple<List<RexNode>, List<RexNode>, List<RexNode>> splitFilters(RexBuilder rexBuilder, DruidQuery input, List<RexNode> validPreds, List<RexNode> nonValidPreds, int timestampFieldIdx) {
            ArrayList<RexNode> timeRangeNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> pushableNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> nonPushableNodes = new ArrayList<RexNode>(nonValidPreds);
            for (RexNode conj : validPreds) {
                RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
                conj.accept((RexVisitor)visitor);
                if (visitor.inputPosReferenced.contains(timestampFieldIdx) && visitor.inputPosReferenced.size() == 1) {
                    timeRangeNodes.add(conj);
                    continue;
                }
                pushableNodes.add(conj);
            }
            return ImmutableTriple.of(timeRangeNodes, pushableNodes, nonPushableNodes);
        }
    }
}

