/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.adapter.splunk.SplunkDriverVersion;
import org.apache.calcite.adapter.splunk.SplunkSchema;
import org.apache.calcite.adapter.splunk.search.SearchResultListener;
import org.apache.calcite.adapter.splunk.search.SplunkConnection;
import org.apache.calcite.adapter.splunk.search.SplunkConnectionImpl;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;

public class SplunkDriver
extends Driver {
    protected SplunkDriver() {
    }

    protected String getConnectStringPrefix() {
        return "jdbc:splunk:";
    }

    protected DriverVersion createDriverVersion() {
        return new SplunkDriverVersion();
    }

    public Connection connect(String url, Properties info) throws SQLException {
        SplunkConnection splunkConnection;
        Connection connection = super.connect(url, info);
        CalciteConnection calciteConnection = (CalciteConnection)connection;
        try {
            String url1 = info.getProperty("url");
            if (url1 == null) {
                throw new IllegalArgumentException("Must specify 'url' property");
            }
            if (url1.equals("mock")) {
                splunkConnection = new MockSplunkConnection();
            } else {
                String user = info.getProperty("user");
                if (user == null) {
                    throw new IllegalArgumentException("Must specify 'user' property");
                }
                String password = info.getProperty("password");
                if (password == null) {
                    throw new IllegalArgumentException("Must specify 'password' property");
                }
                URL url2 = new URL(url1);
                splunkConnection = new SplunkConnectionImpl(url2, user, password);
            }
        }
        catch (Exception e) {
            throw new SQLException("Cannot connect", e);
        }
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add("splunk", (Schema)new SplunkSchema(splunkConnection));
        return connection;
    }

    static {
        new SplunkDriver().register();
    }

    private static class WrappingSplunkConnection
    implements SplunkConnection {
        private final SplunkConnection connection;

        WrappingSplunkConnection(SplunkConnection connection) {
            this.connection = connection;
        }

        @Override
        public void getSearchResults(String search, Map<String, String> otherArgs, List<String> fieldList, SearchResultListener srl) {
            System.out.println("search='" + search + "', otherArgs=" + otherArgs + ", fieldList='" + fieldList);
        }

        @Override
        public Enumerator<Object> getSearchResultEnumerator(String search, Map<String, String> otherArgs, List<String> fieldList) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockSplunkConnection
    implements SplunkConnection {
        private MockSplunkConnection() {
        }

        @Override
        public Enumerator<Object> getSearchResultEnumerator(String search, Map<String, String> otherArgs, List<String> fieldList) {
            throw null;
        }

        @Override
        public void getSearchResults(String search, Map<String, String> otherArgs, List<String> fieldList, SearchResultListener srl) {
            throw new UnsupportedOperationException();
        }
    }
}

