/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.splunk.ImmutableSplunkPushDownRule;
import org.apache.calcite.adapter.splunk.SplunkTableScan;
import org.apache.calcite.adapter.splunk.util.StringUtils;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.immutables.value.Value;
import org.slf4j.Logger;

@Value.Enclosing
public class SplunkPushDownRule
extends RelRule<Config> {
    private static final Logger LOGGER = StringUtils.getClassTracer(SplunkPushDownRule.class);
    private static final Set<SqlKind> SUPPORTED_OPS = ImmutableSet.of((Object)SqlKind.CAST, (Object)SqlKind.EQUALS, (Object)SqlKind.LESS_THAN, (Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)SqlKind.GREATER_THAN, (Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object[])new SqlKind[]{SqlKind.NOT_EQUALS, SqlKind.LIKE, SqlKind.AND, SqlKind.OR, SqlKind.NOT});
    public static final SplunkPushDownRule PROJECT_ON_FILTER = ImmutableSplunkPushDownRule.Config.builder().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(LogicalFilter.class).oneInput(b2 -> b2.operand(LogicalProject.class).oneInput(b3 -> b3.operand(SplunkTableScan.class).noInputs())))).build().withId("proj on filter on proj").toRule();
    public static final SplunkPushDownRule FILTER_ON_PROJECT = ImmutableSplunkPushDownRule.Config.builder().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(LogicalProject.class).oneInput(b2 -> b2.operand(SplunkTableScan.class).noInputs()))).build().withId("filter on proj").toRule();
    public static final SplunkPushDownRule FILTER = ImmutableSplunkPushDownRule.Config.builder().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(SplunkTableScan.class).noInputs())).build().withId("filter").toRule();
    public static final SplunkPushDownRule PROJECT = ImmutableSplunkPushDownRule.Config.builder().withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(SplunkTableScan.class).noInputs())).build().withId("proj").toRule();

    protected SplunkPushDownRule(Config config) {
        super((RelRule.Config)config);
    }

    @Deprecated
    protected SplunkPushDownRule(RelOptRuleOperand operand, String id) {
        this(ImmutableSplunkPushDownRule.Config.builder().withOperandSupplier(b -> b.exactly(operand)).build().withId(id));
    }

    @Deprecated
    protected SplunkPushDownRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String id) {
        this(ImmutableSplunkPushDownRule.Config.builder().withOperandSupplier(b -> b.exactly(operand)).withRelBuilderFactory(relBuilderFactory).build().withId(id));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMatch(RelOptRuleCall call) {
        String filterString;
        LOGGER.debug(this.description);
        int relLength = call.rels.length;
        SplunkTableScan splunkRel = (SplunkTableScan)call.rels[relLength - 1];
        LogicalProject topProj = null;
        LogicalProject bottomProj = null;
        RelDataType topRow = splunkRel.getRowType();
        int filterIdx = 2;
        if (call.rels[relLength - 2] instanceof LogicalProject) {
            bottomProj = (LogicalProject)call.rels[relLength - 2];
            filterIdx = 3;
            topRow = bottomProj.getRowType();
        }
        if (filterIdx <= relLength && call.rels[relLength - filterIdx] instanceof LogicalFilter) {
            LogicalFilter filter = (LogicalFilter)call.rels[relLength - filterIdx];
            int topProjIdx = filterIdx + 1;
            if (topProjIdx <= relLength && call.rels[relLength - topProjIdx] instanceof LogicalProject) {
                topProj = (LogicalProject)call.rels[relLength - topProjIdx];
            }
            RexCall filterCall = (RexCall)filter.getCondition();
            SqlOperator op = filterCall.getOperator();
            List operands = filterCall.getOperands();
            LOGGER.debug("fieldNames: {}", (Object)SplunkPushDownRule.getFieldsString(topRow));
            StringBuilder buf = new StringBuilder();
            if (!SplunkPushDownRule.getFilter(op, operands, buf, topRow.getFieldNames())) return;
            filterString = buf.toString();
        } else {
            filterString = "";
        }
        if (topProj != null) {
            topRow = topProj.getRowType();
        }
        LOGGER.debug("pre transformTo fieldNames: {}", (Object)SplunkPushDownRule.getFieldsString(topRow));
        call.transformTo(this.appendSearchString(filterString, splunkRel, topProj, bottomProj, topRow, null));
    }

    protected RelNode appendSearchString(String toAppend, SplunkTableScan splunkRel, LogicalProject topProj, LogicalProject bottomProj, RelDataType topRow, RelDataType bottomRow) {
        List topFields;
        RelOptCluster cluster = splunkRel.getCluster();
        StringBuilder updateSearchStr = new StringBuilder(splunkRel.search);
        if (!toAppend.isEmpty()) {
            updateSearchStr.append(" ").append(toAppend);
        }
        ArrayList<RelDataTypeField> bottomFields = bottomRow == null ? null : bottomRow.getFieldList();
        List list = topFields = topRow == null ? null : topRow.getFieldList();
        if (bottomFields == null) {
            bottomFields = splunkRel.getRowType().getFieldList();
        }
        if (bottomProj != null) {
            ArrayList<RelDataTypeField> tmp = new ArrayList<RelDataTypeField>();
            List dRow = bottomProj.getRowType().getFieldList();
            for (Object rn : bottomProj.getProjects()) {
                RelDataTypeField rdtf;
                if (rn instanceof RexSlot) {
                    RexSlot rs = (RexSlot)rn;
                    rdtf = (RelDataTypeField)bottomFields.get(rs.getIndex());
                } else {
                    rdtf = (RelDataTypeField)dRow.get(tmp.size());
                }
                tmp.add(rdtf);
            }
            bottomFields = tmp;
        }
        ArrayList<Pair> renames = new ArrayList<Pair>();
        ArrayList<RelDataTypeField> newFields = bottomFields;
        if (topProj != null) {
            LOGGER.debug("topProj: {}", (Object)topProj.getPermutation());
            newFields = new ArrayList();
            int i = 0;
            for (RexNode rn : topProj.getProjects()) {
                RexInputRef rif = (RexInputRef)rn;
                RelDataTypeField field = (RelDataTypeField)bottomFields.get(rif.getIndex());
                if (!((RelDataTypeField)bottomFields.get(rif.getIndex())).getName().equals(((RelDataTypeField)topFields.get(i)).getName())) {
                    renames.add(Pair.of((Object)((RelDataTypeField)bottomFields.get(rif.getIndex())).getName(), (Object)((RelDataTypeField)topFields.get(i)).getName()));
                    field = (RelDataTypeField)topFields.get(i);
                }
                newFields.add(field);
            }
        }
        if (!renames.isEmpty()) {
            updateSearchStr.append("| rename ");
            for (Pair p : renames) {
                updateSearchStr.append((String)p.left).append(" AS ").append((String)p.right).append(" ");
            }
        }
        RelDataType resultType = cluster.getTypeFactory().createStructType((List)newFields);
        String searchWithFilter = updateSearchStr.toString();
        SplunkTableScan rel = new SplunkTableScan(cluster, splunkRel.getTable(), splunkRel.splunkTable, searchWithFilter, splunkRel.earliest, splunkRel.latest, resultType.getFieldNames());
        LOGGER.debug("end of appendSearchString fieldNames: {}", (Object)rel.getRowType().getFieldNames());
        return rel;
    }

    private static RelNode addProjectionRule(LogicalProject proj, RelNode rel) {
        if (proj == null) {
            return rel;
        }
        return LogicalProject.create((RelNode)rel, (List)proj.getHints(), (List)proj.getProjects(), (RelDataType)proj.getRowType());
    }

    private static boolean getFilter(SqlOperator op, List<RexNode> operands, StringBuilder s, List<String> fieldNames) {
        if (!SplunkPushDownRule.valid(op.getKind())) {
            return false;
        }
        boolean like = false;
        switch (op.getKind()) {
            case NOT: {
                s.append(" NOT ");
                break;
            }
            case CAST: {
                return SplunkPushDownRule.asd(false, operands, s, fieldNames, 0);
            }
            case LIKE: {
                like = true;
                break;
            }
        }
        for (int i = 0; i < operands.size(); ++i) {
            if (!SplunkPushDownRule.asd(like, operands, s, fieldNames, i)) {
                return false;
            }
            if (!(op instanceof SqlBinaryOperator) || i != 0) continue;
            s.append(" ").append(op).append(" ");
        }
        return true;
    }

    private static boolean asd(boolean like, List<RexNode> operands, StringBuilder s, List<String> fieldNames, int i) {
        RexNode operand = operands.get(i);
        if (operand instanceof RexCall) {
            s.append("(");
            RexCall call = (RexCall)operand;
            boolean b = SplunkPushDownRule.getFilter(call.getOperator(), call.getOperands(), s, fieldNames);
            if (!b) {
                return false;
            }
            s.append(")");
        } else if (operand instanceof RexInputRef) {
            if (i != 0) {
                return false;
            }
            int fieldIndex = ((RexInputRef)operand).getIndex();
            String name = fieldNames.get(fieldIndex);
            s.append(name);
        } else {
            String tmp = SplunkPushDownRule.toString(like, (RexLiteral)operand);
            if (tmp == null) {
                return false;
            }
            s.append(tmp);
        }
        return true;
    }

    private static boolean valid(SqlKind kind) {
        return SUPPORTED_OPS.contains(kind);
    }

    private static String toString(SqlOperator op) {
        if (op.equals((Object)SqlStdOperatorTable.LIKE)) {
            return SqlStdOperatorTable.EQUALS.toString();
        }
        if (op.equals((Object)SqlStdOperatorTable.NOT_EQUALS)) {
            return "!=";
        }
        return op.toString();
    }

    public static String searchEscape(String str) {
        if (str.isEmpty()) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(str.length());
        boolean quote = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
            quote |= !Character.isLetterOrDigit(c) && c != '_';
        }
        if (quote || sb.length() != str.length()) {
            sb.insert(0, '\"');
            sb.append('\"');
            return sb.toString();
        }
        return str;
    }

    private static String toString(boolean like, RexLiteral literal) {
        String value = null;
        SqlTypeName litSqlType = literal.getTypeName();
        if (SqlTypeName.NUMERIC_TYPES.contains(litSqlType)) {
            value = literal.getValue().toString();
        } else if (litSqlType == SqlTypeName.CHAR) {
            value = ((NlsString)literal.getValue()).getValue();
            if (like) {
                value = value.replace("%", "*");
            }
            value = SplunkPushDownRule.searchEscape(value);
        }
        return value;
    }

    protected void transformToFarragoUdxRel(RelOptRuleCall call, SplunkTableScan splunkRel, LogicalFilter filter, LogicalProject topProj, LogicalProject bottomProj) {
        assert (false);
    }

    public static String getFieldsString(RelDataType row) {
        return row.getFieldNames().toString();
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        default public SplunkPushDownRule toRule() {
            return new SplunkPushDownRule(this);
        }

        default public Config withOperandFor(Class<? extends RelNode> relClass) {
            return (Config)this.withOperandSupplier(b -> b.operand(relClass).anyInputs()).as(Config.class);
        }

        default public Config withId(String id) {
            return (Config)this.withDescription("SplunkPushDownRule: " + id).as(Config.class);
        }
    }
}

