/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.Service;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.activemq.ActiveMQConfiguration;
import org.apache.camel.component.activemq.ActiveMQEndpoint;
import org.apache.camel.component.activemq.ActiveMQQueueEndpoint;
import org.apache.camel.component.activemq.ActiveMQTemporaryQueueEndpoint;
import org.apache.camel.component.activemq.ActiveMQTemporaryTopicEndpoint;
import org.apache.camel.component.activemq.OriginalDestinationPropagateStrategy;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.URISupport;
import org.springframework.jms.connection.SingleConnectionFactory;

@Component(value="activemq")
public class ActiveMQComponent
extends JmsComponent {
    private final CopyOnWriteArrayList<SingleConnectionFactory> singleConnectionFactoryList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Service> pooledConnectionFactoryServiceList = new CopyOnWriteArrayList();

    public ActiveMQComponent() {
    }

    public ActiveMQComponent(CamelContext context) {
        super(context);
    }

    public ActiveMQComponent(ActiveMQConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public static ActiveMQComponent activeMQComponent() {
        return new ActiveMQComponent();
    }

    public static ActiveMQComponent activeMQComponent(String brokerURL) {
        ActiveMQComponent answer = new ActiveMQComponent();
        if (answer.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)answer.getConfiguration()).setBrokerURL(brokerURL);
        }
        return answer;
    }

    public String getBrokerURL() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.getBrokerURL();
        }
        return null;
    }

    @Metadata(label="common")
    public void setBrokerURL(String brokerURL) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setBrokerURL(brokerURL);
        }
    }

    @Metadata(defaultValue="false", label="advanced")
    public void setTrustAllPackages(boolean trustAllPackages) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setTrustAllPackages(trustAllPackages);
        }
    }

    public boolean isTrustAllPackages() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.isTrustAllPackages();
        }
        return false;
    }

    @Metadata(defaultValue="true", label="common")
    public void setUsePooledConnection(boolean usePooledConnection) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setUsePooledConnection(usePooledConnection);
        }
    }

    public boolean isUsePooledConnection() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.isUsePooledConnection();
        }
        return true;
    }

    @Metadata(defaultValue="false", label="common")
    public void setUseSingleConnection(boolean useSingleConnection) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setUseSingleConnection(useSingleConnection);
        }
    }

    public boolean isUseSingleConnection() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.isUseSingleConnection();
        }
        return false;
    }

    protected void setProperties(Endpoint bean, Map<String, Object> parameters) throws Exception {
        Object usePooledConnection;
        Object useSingleConnection = parameters.remove("useSingleConnection");
        if (useSingleConnection != null) {
            ((ActiveMQConfiguration)((JmsEndpoint)bean).getConfiguration()).setUseSingleConnection((Boolean)PropertyConfigurerSupport.property((CamelContext)this.getCamelContext(), Boolean.TYPE, (Object)useSingleConnection));
        }
        if ((usePooledConnection = parameters.remove("usePooledConnection")) != null) {
            ((ActiveMQConfiguration)((JmsEndpoint)bean).getConfiguration()).setUsePooledConnection((Boolean)PropertyConfigurerSupport.property((CamelContext)this.getCamelContext(), Boolean.TYPE, (Object)usePooledConnection));
        }
        super.setProperties(bean, parameters);
    }

    protected void addPooledConnectionFactoryService(Service pooledConnectionFactoryService) {
        this.pooledConnectionFactoryServiceList.add(pooledConnectionFactoryService);
    }

    protected void addSingleConnectionFactory(SingleConnectionFactory singleConnectionFactory) {
        this.singleConnectionFactoryList.add(singleConnectionFactory);
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        Map options = PropertiesHelper.extractProperties(parameters, (String)"destination.");
        String query = URISupport.createQueryString((Map)options);
        if (ObjectHelper.isNotEmpty((String)query)) {
            return path + "?" + query;
        }
        return path;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.getMessageCreatedStrategy() == null) {
            this.setMessageCreatedStrategy(new OriginalDestinationPropagateStrategy());
        }
    }

    protected void doStop() throws Exception {
        for (Service service : this.pooledConnectionFactoryServiceList) {
            try {
                service.stop();
            }
            catch (Exception exception) {}
        }
        this.pooledConnectionFactoryServiceList.clear();
        for (SingleConnectionFactory singleConnectionFactory : this.singleConnectionFactoryList) {
            try {
                singleConnectionFactory.destroy();
            }
            catch (Exception exception) {}
        }
        this.singleConnectionFactoryList.clear();
        super.doStop();
    }

    public void setConfiguration(JmsConfiguration configuration) {
        if (configuration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)configuration;
            activeMQConfiguration.setActiveMQComponent(this);
        }
        super.setConfiguration(configuration);
    }

    protected JmsConfiguration createConfiguration() {
        ActiveMQConfiguration answer = new ActiveMQConfiguration();
        answer.setActiveMQComponent(this);
        return answer;
    }

    protected JmsEndpoint createTemporaryTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new ActiveMQTemporaryTopicEndpoint(uri, component, subject, configuration);
    }

    protected JmsEndpoint createTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new ActiveMQEndpoint(uri, component, subject, true, configuration);
    }

    protected JmsEndpoint createTemporaryQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new ActiveMQTemporaryQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }

    protected JmsEndpoint createQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new ActiveMQQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }
}

