/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import java.util.Base64;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerEndpoint;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerOperations;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DescribeSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType;
import software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.RotateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse;

public class SecretsManagerProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsManagerProducer.class);
    private transient String secretsManagerProducerToString;
    private WritableHealthCheckRepository healthCheckRepository;
    private HealthCheck producerHealthCheck;

    public SecretsManagerProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listSecrets: {
                this.listSecrets(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case createSecret: {
                this.createSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case getSecret: {
                this.getSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case describeSecret: {
                this.describeSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case deleteSecret: {
                this.deleteSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case rotateSecret: {
                this.rotateSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case updateSecret: {
                this.updateSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case replicateSecretToRegions: {
                this.replicateSecretToRegions(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            case restoreSecret: {
                this.restoreSecret(this.getEndpoint().getSecretsManagerClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private SecretsManagerOperations determineOperation(Exchange exchange) {
        SecretsManagerOperations operation = (SecretsManagerOperations)((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerOperation", SecretsManagerOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected SecretsManagerConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.secretsManagerProducerToString == null) {
            this.secretsManagerProducerToString = "SecretsManagerProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.secretsManagerProducerToString;
    }

    public SecretsManagerEndpoint getEndpoint() {
        return (SecretsManagerEndpoint)super.getEndpoint();
    }

    private void listSecrets(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        ListSecretsResponse result;
        ListSecretsRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ListSecretsRequest)exchange.getIn().getMandatoryBody(ListSecretsRequest.class);
        } else {
            ListSecretsRequest.Builder builder = ListSecretsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerMaxResults"))) {
                int maxRes = (Integer)exchange.getIn().getHeader("CamelAwsSecretsManagerMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxRes));
            }
            request = (ListSecretsRequest)builder.build();
        }
        try {
            result = secretsManagerClient.listSecrets(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("List Secrets command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void createSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        CreateSecretResponse result;
        CreateSecretRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (CreateSecretRequest)exchange.getIn().getMandatoryBody(CreateSecretRequest.class);
        } else {
            CreateSecretRequest.Builder builder = CreateSecretRequest.builder();
            String payload = (String)exchange.getIn().getMandatoryBody(String.class);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretName"))) {
                throw new IllegalArgumentException("Secret Name must be specified");
            }
            String secretName = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretName", String.class);
            builder.name(secretName);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretDescription"))) {
                String descr = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretDescription", String.class);
                builder.description(descr);
            }
            if (this.getConfiguration().isBinaryPayload()) {
                builder.secretBinary(SdkBytes.fromUtf8String((String)Base64.getEncoder().encodeToString(payload.getBytes())));
            } else {
                builder.secretString(payload);
            }
            request = (CreateSecretRequest)builder.build();
        }
        try {
            result = secretsManagerClient.createSecret(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Create Secret command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void getSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        GetSecretValueResponse result;
        GetSecretValueRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (GetSecretValueRequest)exchange.getIn().getMandatoryBody(GetSecretValueRequest.class);
        } else {
            GetSecretValueRequest.Builder builder = GetSecretValueRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            request = (GetSecretValueRequest)builder.build();
        }
        try {
            result = secretsManagerClient.getSecretValue(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Get Secret value command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        if (this.getConfiguration().isBinaryPayload()) {
            message.setBody((Object)new String(Base64.getDecoder().decode(result.secretBinary().asByteBuffer()).array()));
        } else {
            message.setBody((Object)result.secretString());
        }
        if (ObjectHelper.isNotEmpty((String)result.versionId())) {
            exchange.getMessage().setHeader("CamelAwsSecretsManagerSecretVersionId", (Object)result.versionId());
        }
    }

    private void describeSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        DescribeSecretResponse result;
        DescribeSecretRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (DescribeSecretRequest)exchange.getIn().getMandatoryBody(DescribeSecretRequest.class);
        } else {
            DescribeSecretRequest.Builder builder = DescribeSecretRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            request = (DescribeSecretRequest)builder.build();
        }
        try {
            result = secretsManagerClient.describeSecret(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Describe Secret value command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        DeleteSecretResponse result;
        DeleteSecretRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (DeleteSecretRequest)exchange.getIn().getMandatoryBody(DeleteSecretRequest.class);
        } else {
            DeleteSecretRequest.Builder builder = DeleteSecretRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            request = (DeleteSecretRequest)builder.build();
        }
        try {
            result = secretsManagerClient.deleteSecret(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Delete Secret value command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void rotateSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        RotateSecretResponse result;
        RotateSecretRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (RotateSecretRequest)exchange.getIn().getMandatoryBody(RotateSecretRequest.class);
        } else {
            RotateSecretRequest.Builder builder = RotateSecretRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerLambdaRotationFunctionArn"))) {
                String lambdaRotationArn = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerLambdaRotationFunctionArn", String.class);
                builder.rotationLambdaARN(lambdaRotationArn);
            }
            request = (RotateSecretRequest)builder.build();
        }
        try {
            result = secretsManagerClient.rotateSecret(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Rotate Secret value command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void updateSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        UpdateSecretResponse result;
        UpdateSecretRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (UpdateSecretRequest)exchange.getIn().getMandatoryBody(UpdateSecretRequest.class);
        } else {
            UpdateSecretRequest.Builder builder = UpdateSecretRequest.builder();
            String payload = (String)exchange.getIn().getMandatoryBody(String.class);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretDescription"))) {
                String descr = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretDescription", String.class);
                builder.description(descr);
            }
            if (this.getConfiguration().isBinaryPayload()) {
                builder.secretBinary(SdkBytes.fromUtf8String((String)Base64.getEncoder().encodeToString(payload.getBytes())));
            } else {
                builder.secretString(payload);
            }
            request = (UpdateSecretRequest)builder.build();
        }
        try {
            result = secretsManagerClient.updateSecret(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Update Secret command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void replicateSecretToRegions(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        ReplicateSecretToRegionsResponse result;
        ReplicateSecretToRegionsRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (ReplicateSecretToRegionsRequest)exchange.getIn().getMandatoryBody(ReplicateSecretToRegionsRequest.class);
        } else {
            ReplicateSecretToRegionsRequest.Builder builder = ReplicateSecretToRegionsRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretReplicationRegions"))) {
                String[] s;
                String regions = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretReplicationRegions", String.class);
                for (String region : s = regions.split(",")) {
                    ReplicaRegionType.Builder regionType = ReplicaRegionType.builder();
                    regionType.region(region);
                    builder.addReplicaRegions(new ReplicaRegionType[]{(ReplicaRegionType)regionType.build()});
                }
            } else {
                throw new IllegalArgumentException("Replica Regions must be specified");
            }
            request = (ReplicateSecretToRegionsRequest)builder.build();
        }
        try {
            result = secretsManagerClient.replicateSecretToRegions(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Replicate Secret to region command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void restoreSecret(SecretsManagerClient secretsManagerClient, Exchange exchange) throws InvalidPayloadException {
        RestoreSecretResponse result;
        RestoreSecretRequest request = null;
        if (this.getConfiguration().isPojoRequest()) {
            request = (RestoreSecretRequest)exchange.getIn().getMandatoryBody(RestoreSecretRequest.class);
        } else {
            RestoreSecretRequest.Builder builder = RestoreSecretRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId"))) {
                throw new IllegalArgumentException("Secret Id must be specified");
            }
            String secretId = (String)exchange.getIn().getHeader("CamelAwsSecretsManagerSecretId", String.class);
            builder.secretId(secretId);
            request = (RestoreSecretRequest)builder.build();
        }
        try {
            result = secretsManagerClient.restoreSecret(request);
        }
        catch (AwsServiceException ase) {
            LOG.trace("Restore Secret value command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
        Message message = SecretsManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new SecretsManagerProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

