/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager.client;

import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.client.SecretsManagerInternalClient;
import org.apache.camel.component.aws.secretsmanager.client.impl.SecretsManagerClientIAMOptimized;
import org.apache.camel.component.aws.secretsmanager.client.impl.SecretsManagerClientIAMProfileOptimized;
import org.apache.camel.component.aws.secretsmanager.client.impl.SecretsManagerClientSessionTokenImpl;
import org.apache.camel.component.aws.secretsmanager.client.impl.SecretsManagerClientStandardImpl;

public final class SecretsManagerClientFactory {
    private SecretsManagerClientFactory() {
    }

    public static SecretsManagerInternalClient getSecretsManagerClient(SecretsManagerConfiguration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new SecretsManagerClientIAMOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new SecretsManagerClientIAMProfileOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new SecretsManagerClientSessionTokenImpl(configuration);
        }
        return new SecretsManagerClientStandardImpl(configuration);
    }
}

