/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.translate;

import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.translate.Translate2Configuration;
import org.apache.camel.component.aws2.translate.Translate2Endpoint;
import org.apache.camel.component.aws2.translate.Translate2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;

public class Translate2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Translate2Producer.class);
    private transient String translateProducerToString;

    public Translate2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case translateText: {
                this.translateText(this.getEndpoint().getTranslateClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private Translate2Operations determineOperation(Exchange exchange) {
        Translate2Operations operation = (Translate2Operations)((Object)exchange.getIn().getHeader("CamelAwsTranslateOperation", Translate2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected Translate2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.translateProducerToString == null) {
            this.translateProducerToString = "TranslateProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.translateProducerToString;
    }

    public Translate2Endpoint getEndpoint() {
        return (Translate2Endpoint)super.getEndpoint();
    }

    private void translateText(TranslateClient translateClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof TranslateTextRequest) {
                TranslateTextResponse result;
                try {
                    result = translateClient.translateText((TranslateTextRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Translate Text command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Translate2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result.translatedText());
            }
        } else {
            TranslateTextResponse result;
            String target;
            String source;
            TranslateTextRequest.Builder request = TranslateTextRequest.builder();
            if (!this.getConfiguration().isAutodetectSourceLanguage()) {
                if (ObjectHelper.isEmpty((String)this.getConfiguration().getSourceLanguage()) && ObjectHelper.isEmpty((String)this.getConfiguration().getTargetLanguage())) {
                    source = (String)exchange.getIn().getHeader("CamelAwsTranslateSourceLanguage", String.class);
                    target = (String)exchange.getIn().getHeader("CamelAwsTranslateTargetLanguage", String.class);
                    if (ObjectHelper.isEmpty((String)source) || ObjectHelper.isEmpty((String)target)) {
                        throw new IllegalArgumentException("Source and target language must be specified as headers or endpoint options");
                    }
                    request.sourceLanguageCode(source);
                    request.targetLanguageCode(target);
                } else {
                    request.sourceLanguageCode(this.getConfiguration().getSourceLanguage());
                    request.targetLanguageCode(this.getConfiguration().getTargetLanguage());
                }
            } else {
                source = "auto";
                if (ObjectHelper.isEmpty((String)this.getConfiguration().getTargetLanguage())) {
                    target = (String)exchange.getIn().getHeader("CamelAwsTranslateTargetLanguage", String.class);
                    if (ObjectHelper.isEmpty((String)source) || ObjectHelper.isEmpty((String)target)) {
                        throw new IllegalArgumentException("Target language must be specified when autodetection of source language is enabled");
                    }
                    request.sourceLanguageCode(source);
                    request.targetLanguageCode(target);
                } else {
                    request.sourceLanguageCode(source);
                    request.targetLanguageCode(this.getConfiguration().getTargetLanguage());
                }
            }
            if (!ObjectHelper.isEmpty((Collection)((Collection)exchange.getIn().getHeader("CamelAwsTranslateTerminologyNames", Collection.class)))) {
                Collection terminologies = (Collection)exchange.getIn().getHeader("CamelAwsTranslateTerminologyNames", Collection.class);
                request.terminologyNames(terminologies);
            }
            request.text((String)exchange.getMessage().getBody(String.class));
            try {
                result = translateClient.translateText((TranslateTextRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Translate Text command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Translate2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result.translatedText());
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

