/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-storage-blob:application-cloudevents")
public class AzureStorageBlobCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.storage.blob.getBlob");
        if (message.getHeaders().containsKey("CamelAzureStorageBlobETag")) {
            headers.put("CamelCloudEventSource", "azure.storage.blob." + (String)message.getHeader("CamelAzureStorageBlobETag", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAzureStorageBlobBlobName", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

