/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.core.util.Base64Util;
import com.azure.storage.blob.models.Block;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.camel.component.azure.storage.blob.BlobUtils;

public final class BlobBlock {
    private final InputStream blockStream;
    private final Block blockEntry;

    private BlobBlock(Block blockEntry, InputStream blockStream) {
        this.blockStream = blockStream;
        this.blockEntry = blockEntry;
    }

    public static BlobBlock createBlobBlock(InputStream inputStream) throws IOException {
        return BlobBlock.createBlobBlock(Base64Util.encodeToString((byte[])UUID.randomUUID().toString().getBytes()), inputStream);
    }

    public static BlobBlock createBlobBlock(String blockId, InputStream inputStream) throws IOException {
        return BlobBlock.createBlobBlock(blockId, BlobUtils.getInputStreamLength(inputStream), inputStream);
    }

    public static BlobBlock createBlobBlock(String blockId, long size, InputStream inputStream) {
        Block block = new Block().setName(blockId).setSizeLong(size);
        return new BlobBlock(block, inputStream);
    }

    public InputStream getBlockStream() {
        return this.blockStream;
    }

    public Block getBlockEntry() {
        return this.blockEntry;
    }
}

