/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.component.cm.CMMessage;
import org.apache.camel.component.cm.CMSender;
import org.apache.camel.component.cm.exceptions.CMDirectException;
import org.apache.camel.component.cm.exceptions.XMLConstructionException;
import org.apache.camel.component.cm.exceptions.cmresponse.CMResponseException;
import org.apache.camel.component.cm.exceptions.cmresponse.InsufficientBalanceException;
import org.apache.camel.component.cm.exceptions.cmresponse.InvalidProductTokenException;
import org.apache.camel.component.cm.exceptions.cmresponse.NoAccountFoundForProductTokenException;
import org.apache.camel.component.cm.exceptions.cmresponse.UnknownErrorException;
import org.apache.camel.component.cm.exceptions.cmresponse.UnroutableMessageException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CMSenderOneMessageImpl
implements CMSender {
    private static final Logger LOG = LoggerFactory.getLogger(CMSenderOneMessageImpl.class);
    private final String url;
    private final UUID productToken;

    public CMSenderOneMessageImpl(String url, UUID productToken) {
        this.url = url;
        this.productToken = productToken;
    }

    @Override
    public void send(CMMessage cmMessage) {
        String xml = this.createXml(cmMessage);
        this.doHttpPost(this.url, xml);
    }

    private String createXml(CMMessage message) {
        try {
            String id;
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            DOMImplementation impl = docBuilder.getDOMImplementation();
            Document doc = impl.createDocument(null, "MESSAGES", null);
            Element root = doc.getDocumentElement();
            Element authenticationElement = doc.createElement("AUTHENTICATION");
            Element productTokenElement = doc.createElement("PRODUCTTOKEN");
            authenticationElement.appendChild(productTokenElement);
            Text productTokenValue = doc.createTextNode("" + this.productToken);
            productTokenElement.appendChild(productTokenValue);
            root.appendChild(authenticationElement);
            Element msgElement = doc.createElement("MSG");
            root.appendChild(msgElement);
            Element fromElement = doc.createElement("FROM");
            fromElement.appendChild(doc.createTextNode(message.getSender()));
            msgElement.appendChild(fromElement);
            Element bodyElement = doc.createElement("BODY");
            bodyElement.appendChild(doc.createTextNode(message.getMessage()));
            msgElement.appendChild(bodyElement);
            Element toElement = doc.createElement("TO");
            toElement.appendChild(doc.createTextNode(message.getPhoneNumber()));
            msgElement.appendChild(toElement);
            if (message.isUnicode()) {
                Element dcsElement = doc.createElement("DCS");
                dcsElement.appendChild(doc.createTextNode("8"));
                msgElement.appendChild(dcsElement);
            }
            if ((id = message.getIdAsString()) != null && !id.isEmpty()) {
                Element refElement = doc.createElement("REFERENCE");
                refElement.appendChild(doc.createTextNode(message.getIdAsString()));
                msgElement.appendChild(refElement);
            }
            if (message.isMultipart()) {
                Element minMessagePartsElement = doc.createElement("MINIMUMNUMBEROFMESSAGEPARTS");
                minMessagePartsElement.appendChild(doc.createTextNode("1"));
                msgElement.appendChild(minMessagePartsElement);
                Element maxMessagePartsElement = doc.createElement("MAXIMUMNUMBEROFMESSAGEPARTS");
                maxMessagePartsElement.appendChild(doc.createTextNode(Integer.toString(message.getMultiparts())));
                msgElement.appendChild(maxMessagePartsElement);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer aTransformer = transformerFactory.newTransformer();
            aTransformer.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(doc);
            StreamResult dest = new StreamResult(xml);
            aTransformer.transform(src, dest);
            return xml.toString();
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new XMLConstructionException(String.format("Cant serialize CMMessage %s", message), e);
        }
    }

    private void doHttpPost(String urlString, String requestString) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(urlString);
        post.setEntity((HttpEntity)new StringEntity(requestString, StandardCharsets.UTF_8));
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            LOG.debug("Response Code : {}", (Object)statusCode);
            if (statusCode == 400) {
                throw new CMDirectException("CM Component and CM API show some kind of inconsistency. CM is complaining about not using a post method for the request. And this component only uses POST requests. What happens?");
            }
            if (statusCode != 200) {
                throw new CMDirectException("CM Component and CM API show some kind of inconsistency. The component expects the status code to be 200 or 400. New api released? ");
            }
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
                StringBuffer result = new StringBuffer();
                String line = null;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                line = result.toString();
                if (!line.isEmpty()) {
                    LOG.debug("Result of the request processing: FAILED\n{}", (Object)line);
                    if (line.contains("Unknown error")) {
                        throw new UnknownErrorException();
                    }
                    if (line.contains("No account found") || line.contains("No or incorrect User node found")) {
                        throw new NoAccountFoundForProductTokenException();
                    }
                    if (line.contains("Insufficient balance")) {
                        throw new InsufficientBalanceException();
                    }
                    if (line.contains("Message is unroutable")) {
                        throw new UnroutableMessageException();
                    }
                    if (line.contains("Invalid product token")) {
                        throw new InvalidProductTokenException();
                    }
                    throw new CMResponseException(line);
                }
                LOG.debug("Result of the request processing: Successfully submitted");
            }
        }
        catch (IOException io) {
            throw new CMDirectException(io);
        }
        catch (Exception t2) {
            CMDirectException t2;
            if (!(t2 instanceof CMDirectException)) {
                t2 = new CMDirectException(t2);
            }
            throw (CMDirectException)t2;
        }
    }
}

