/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.messaging.AtomixMessaging;
import org.apache.camel.component.atomix.client.messaging.AtomixMessagingComponent;
import org.apache.camel.component.atomix.client.messaging.AtomixMessagingConfiguration;

public interface AtomixMessagingComponentBuilderFactory {
    public static AtomixMessagingComponentBuilder atomixMessaging() {
        return new AtomixMessagingComponentBuilderImpl();
    }

    public static class AtomixMessagingComponentBuilderImpl
    extends AbstractComponentBuilder<AtomixMessagingComponent>
    implements AtomixMessagingComponentBuilder {
        @Override
        protected AtomixMessagingComponent buildConcreteComponent() {
            return new AtomixMessagingComponent();
        }

        private AtomixMessagingConfiguration getOrCreateConfiguration(AtomixMessagingComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AtomixMessagingConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "atomix": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setAtomix((Atomix)value);
                    return true;
                }
                case "broadcastType": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setBroadcastType((AtomixMessaging.BroadcastType)value);
                    return true;
                }
                case "channelName": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setChannelName((String)value);
                    return true;
                }
                case "configuration": {
                    ((AtomixMessagingComponent)component).setConfiguration((AtomixMessagingConfiguration)value);
                    return true;
                }
                case "configurationUri": {
                    ((AtomixMessagingComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "defaultAction": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setDefaultAction((AtomixMessaging.Action)value);
                    return true;
                }
                case "memberName": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setMemberName((String)value);
                    return true;
                }
                case "nodes": {
                    ((AtomixMessagingComponent)component).setNodes((List)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setResultHeader((String)value);
                    return true;
                }
                case "transportClassName": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setTransportClassName((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AtomixMessagingComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AtomixMessagingComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((AtomixMessagingComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultResourceConfig": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setDefaultResourceConfig((Properties)value);
                    return true;
                }
                case "defaultResourceOptions": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setDefaultResourceOptions((Properties)value);
                    return true;
                }
                case "ephemeral": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setEphemeral(((Boolean)value).booleanValue());
                    return true;
                }
                case "readConsistency": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setReadConsistency((ReadConsistency)value);
                    return true;
                }
                case "resourceConfigs": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setResourceConfigs((Map)value);
                    return true;
                }
                case "resourceOptions": {
                    this.getOrCreateConfiguration((AtomixMessagingComponent)component).setResourceOptions((Map)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AtomixMessagingComponentBuilder
    extends ComponentBuilder<AtomixMessagingComponent> {
        default public AtomixMessagingComponentBuilder atomix(Atomix atomix) {
            this.doSetProperty("atomix", atomix);
            return this;
        }

        default public AtomixMessagingComponentBuilder broadcastType(AtomixMessaging.BroadcastType broadcastType) {
            this.doSetProperty("broadcastType", broadcastType);
            return this;
        }

        default public AtomixMessagingComponentBuilder channelName(String channelName) {
            this.doSetProperty("channelName", channelName);
            return this;
        }

        default public AtomixMessagingComponentBuilder configuration(AtomixMessagingConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AtomixMessagingComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public AtomixMessagingComponentBuilder defaultAction(AtomixMessaging.Action defaultAction) {
            this.doSetProperty("defaultAction", defaultAction);
            return this;
        }

        default public AtomixMessagingComponentBuilder memberName(String memberName) {
            this.doSetProperty("memberName", memberName);
            return this;
        }

        default public AtomixMessagingComponentBuilder nodes(List<Address> nodes) {
            this.doSetProperty("nodes", nodes);
            return this;
        }

        default public AtomixMessagingComponentBuilder resultHeader(String resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }

        default public AtomixMessagingComponentBuilder transportClassName(String transportClassName) {
            this.doSetProperty("transportClassName", transportClassName);
            return this;
        }

        default public AtomixMessagingComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AtomixMessagingComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AtomixMessagingComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AtomixMessagingComponentBuilder defaultResourceConfig(Properties defaultResourceConfig) {
            this.doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }

        default public AtomixMessagingComponentBuilder defaultResourceOptions(Properties defaultResourceOptions) {
            this.doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }

        default public AtomixMessagingComponentBuilder ephemeral(boolean ephemeral) {
            this.doSetProperty("ephemeral", ephemeral);
            return this;
        }

        default public AtomixMessagingComponentBuilder readConsistency(ReadConsistency readConsistency) {
            this.doSetProperty("readConsistency", readConsistency);
            return this;
        }

        default public AtomixMessagingComponentBuilder resourceConfigs(Map<String, Properties> resourceConfigs) {
            this.doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }

        default public AtomixMessagingComponentBuilder resourceOptions(Map<String, Properties> resourceOptions) {
            this.doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }
}

