/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.util.StopWatch;

public final class LoadThroughput {
    private final StopWatch watch = new StopWatch(false);
    private long last;
    private double thp;

    public void update(long currentReading) {
        if (!this.watch.isStarted()) {
            this.watch.restart();
            this.thp = 0.0;
        } else {
            long delta;
            long time = this.watch.takenAndRestart();
            this.thp = time > 0L ? ((delta = currentReading - this.last) > 0L ? 1000.0 / (double)time * (double)delta : 0.0) : 0.0;
        }
        this.last = currentReading;
    }

    public double getThroughput() {
        return this.thp;
    }

    public void reset() {
        this.last = 0L;
        this.thp = 0.0;
    }

    public String toString() {
        return Double.toString(this.thp);
    }
}

