/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho.mqtt5;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.spi.annotations.SendDynamic;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

@SendDynamic(value="paho-mqtt5")
public class PahoMqtt5SendDynamicAware
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private String scheme;

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isLenientProperties() {
        return false;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, null, null);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String originalTopic;
        String topic = this.parseTopicName(entry.getUri());
        if (topic != null && !topic.equals(originalTopic = this.parseTopicName(entry.getOriginalUri()))) {
            String answer = entry.getUri();
            answer = StringHelper.replaceFirst((String)answer, (String)topic, (String)originalTopic);
            return answer;
        }
        return null;
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        if (exchange.getMessage().getHeader("CamelPahoMqtt5OverrideTopic") != null) {
            return null;
        }
        final String destinationName = this.parseTopicName(entry.getUri());
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getMessage().setHeader("CamelPahoMqtt5OverrideTopic", (Object)destinationName);
            }
        };
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    private String parseTopicName(String uri) {
        uri = uri.replaceFirst(this.scheme + "://", ":");
        int pos = (uri = StringHelper.before((String)uri, (String)"?", (String)uri)).indexOf(58);
        if (pos != -1) {
            return uri.substring(pos + 1);
        }
        return null;
    }
}

