/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ShutdownableService;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;

public class DefaultInterceptSendToEndpoint
implements InterceptSendToEndpoint,
ShutdownableService {
    private final CamelContext camelContext;
    private final Endpoint delegate;
    private Processor before;
    private Processor after;
    private boolean skip;

    public DefaultInterceptSendToEndpoint(Endpoint destination, boolean skip) {
        this.camelContext = destination.getCamelContext();
        this.delegate = destination;
        this.skip = skip;
    }

    public void setBefore(Processor before) {
        this.before = before;
    }

    public void setAfter(Processor after) {
        this.after = after;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Processor getBefore() {
        return this.before;
    }

    public Processor getAfter() {
        return this.after;
    }

    public Endpoint getOriginalEndpoint() {
        return this.delegate;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public String getEndpointUri() {
        return this.delegate.getEndpointUri();
    }

    public ExchangePattern getExchangePattern() {
        return this.delegate.getExchangePattern();
    }

    public String getEndpointBaseUri() {
        return this.delegate.getEndpointBaseUri();
    }

    public String getEndpointKey() {
        return this.delegate.getEndpointKey();
    }

    public Exchange createExchange() {
        return this.delegate.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.delegate.createExchange(pattern);
    }

    public void configureExchange(Exchange exchange) {
        this.delegate.configureExchange(exchange);
    }

    public CamelContext getCamelContext() {
        return this.delegate.getCamelContext();
    }

    public Producer createProducer() throws Exception {
        return this.createAsyncProducer();
    }

    public AsyncProducer createAsyncProducer() throws Exception {
        AsyncProducer producer = this.delegate.createAsyncProducer();
        return PluginHelper.getInternalProcessorFactory(this.camelContext).createInterceptSendToEndpointProcessor((InterceptSendToEndpoint)this, this.delegate, producer, this.skip);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.delegate.createConsumer(processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return this.delegate.createPollingConsumer();
    }

    public void configureProperties(Map<String, Object> options) {
        this.delegate.configureProperties(options);
    }

    public void setCamelContext(CamelContext context) {
        this.delegate.setCamelContext(context);
    }

    public boolean isLenientProperties() {
        return this.delegate.isLenientProperties();
    }

    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    public void start() {
        ServiceHelper.startService((Object[])new Object[]{this.before, this.delegate});
    }

    public void stop() {
        ServiceHelper.stopService((Object[])new Object[]{this.delegate, this.before});
    }

    public void shutdown() {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegate, this.before});
    }

    public String toString() {
        return this.delegate.toString();
    }
}

