/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

import java.util.Collection;
import java.util.Locale;

public final class Strings {
    private Strings() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.length() == 0 || "null".equals(text);
    }

    public static String safeNull(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return "";
        }
        return text;
    }

    public static String getOrElse(String text, String defaultValue) {
        return text != null ? text : defaultValue;
    }

    public static String after(String text, String after) {
        int index = text.indexOf(after);
        if (index < 0) {
            return null;
        }
        return text.substring(index + after.length());
    }

    public static String canonicalClassName(String className) {
        int pos = className.indexOf(60);
        if (pos != -1) {
            return className.substring(0, pos);
        }
        return className;
    }

    public static String doubleQuote(String text) {
        return Strings.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return Strings.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String between(String text, String after, String before) {
        if ((text = Strings.after(text, after)) == null) {
            return null;
        }
        return Strings.before(text, before);
    }

    public static String asTitle(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            boolean first;
            boolean upper = Character.isUpperCase(c);
            boolean bl = first = sb.length() == 0;
            if (first) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (upper) {
                char prev = sb.charAt(sb.length() - 1);
                if (!Character.isUpperCase(prev)) {
                    sb.append(' ');
                }
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString().trim();
    }

    public static String before(String text, String before) {
        int index = text.indexOf(before);
        if (index < 0) {
            return null;
        }
        return text.substring(0, index);
    }

    public static String indentCollection(String indent, Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String text : list) {
            sb.append(indent).append(text);
        }
        return sb.toString();
    }

    public static String camelDashToTitle(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        boolean dash = false;
        for (char c : value.toCharArray()) {
            if ('-' == c) {
                dash = true;
                continue;
            }
            if (dash) {
                sb.append(' ');
                sb.append(Character.toUpperCase(c));
            } else if (sb.length() == 0) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            dash = false;
        }
        return sb.toString();
    }

    public static String camelCaseToDash(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder answer = new StringBuilder();
        Character prev = null;
        Character next = null;
        char[] arr = text.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            next = i < arr.length - 1 ? Character.valueOf(arr[i + 1]) : null;
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != null && !Character.isUpperCase(prev.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else if (Character.isUpperCase(ch) && prev != null && next != null && Character.isLowerCase(next.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else {
                answer.append(ch);
            }
            prev = Character.valueOf(ch);
        }
        return answer.toString().toLowerCase(Locale.ENGLISH);
    }
}

