/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.test.CamelQuarkusTestSupport;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

public class CallbackUtil {
    static boolean isPerClass(CamelQuarkusTestSupport testSupport) {
        return CallbackUtil.getLifecycle(testSupport).filter(lc -> lc.equals((Object)TestInstance.Lifecycle.PER_CLASS)).isPresent();
    }

    static Optional<TestInstance.Lifecycle> getLifecycle(CamelQuarkusTestSupport testSupport) {
        if (((Object)((Object)testSupport)).getClass().getAnnotation(TestInstance.class) != null) {
            return Optional.of(((Object)((Object)testSupport)).getClass().getAnnotation(TestInstance.class).value());
        }
        return Optional.empty();
    }

    static void resetContext(CamelQuarkusTestSupport testInstance) {
        if (testInstance.isUseRouteBuilder() && testInstance.createdRoutes != null) {
            try {
                for (String r : testInstance.createdRoutes) {
                    testInstance.context().getRouteController().stopRoute(r);
                    testInstance.context().removeRoute(r);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        testInstance.context().getComponentNames().forEach(cn -> testInstance.context().removeComponent(cn));
        MockEndpoint.resetMocks((CamelContext)testInstance.context());
    }

    static class MockExtensionContext
    implements ExtensionContext {
        private final Optional<TestInstance.Lifecycle> lifecycle;
        private final String currentTestName;
        private final ExtensionContext.Store globalStore;

        public MockExtensionContext(Optional<TestInstance.Lifecycle> lifecycle, String currentTestName) {
            this.lifecycle = lifecycle;
            this.currentTestName = currentTestName;
            this.globalStore = new NamespaceAwareStore(new NamespacedHierarchicalStore(null), ExtensionContext.Namespace.GLOBAL);
        }

        public Optional<ExtensionContext> getParent() {
            return Optional.empty();
        }

        public ExtensionContext getRoot() {
            return null;
        }

        public String getUniqueId() {
            return null;
        }

        public String getDisplayName() {
            return this.currentTestName;
        }

        public Set<String> getTags() {
            return null;
        }

        public Optional<AnnotatedElement> getElement() {
            return Optional.empty();
        }

        public Optional<Class<?>> getTestClass() {
            return Optional.empty();
        }

        public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
            return this.lifecycle;
        }

        public Optional<Object> getTestInstance() {
            return Optional.empty();
        }

        public Optional<TestInstances> getTestInstances() {
            return Optional.empty();
        }

        public Optional<Method> getTestMethod() {
            return Optional.empty();
        }

        public Optional<Throwable> getExecutionException() {
            return Optional.empty();
        }

        public Optional<String> getConfigurationParameter(String key) {
            return Optional.empty();
        }

        public <T> Optional<T> getConfigurationParameter(String key, Function<String, T> transformer) {
            return Optional.empty();
        }

        public void publishReportEntry(Map<String, String> map) {
        }

        public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
            if (namespace == ExtensionContext.Namespace.GLOBAL) {
                return this.globalStore;
            }
            return null;
        }

        public ExecutionMode getExecutionMode() {
            return null;
        }

        public ExecutableInvoker getExecutableInvoker() {
            return null;
        }
    }
}

