/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.springboot.cloud;

import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.component.dns.cloud.DnsServiceDiscoveryFactory;
import org.apache.camel.model.cloud.springboot.DnsServiceCallServiceDiscoveryConfigurationProperties;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.support.PluginHelper;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@Conditional(value={Condition.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={DnsServiceCallServiceDiscoveryConfigurationProperties.class})
public class DnsCloudAutoConfiguration {
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private DnsServiceCallServiceDiscoveryConfigurationProperties configuration;
    @Autowired
    private ConfigurableBeanFactory beanFactory;

    @Lazy
    @Bean(name={"dns-service-discovery"})
    @ConditionalOnClass(value={CamelContext.class})
    public ServiceDiscovery configureServiceDiscoveryFactory() throws Exception {
        DnsServiceDiscoveryFactory factory = new DnsServiceDiscoveryFactory();
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)factory, (Map)CamelPropertiesHelper.getNonNullProperties((CamelContext)this.camelContext, (Object)this.configuration), (boolean)false);
        return factory.newInstance(this.camelContext);
    }

    @PostConstruct
    public void postConstruct() {
        if (this.beanFactory != null) {
            HashMap parameters = new HashMap();
            for (Map.Entry entry : this.configuration.getConfigurations().entrySet()) {
                parameters.clear();
                DnsServiceDiscoveryFactory factory = new DnsServiceDiscoveryFactory();
                BeanIntrospection bi = PluginHelper.getBeanIntrospection((CamelContext)this.camelContext);
                try {
                    bi.getProperties(entry.getValue(), parameters, null, false);
                    CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)factory, parameters, (boolean)false);
                    this.beanFactory.registerSingleton((String)entry.getKey(), (Object)factory.newInstance(this.camelContext));
                }
                catch (Exception e) {
                    throw new BeanCreationException((String)entry.getKey(), e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.cloud.dns", "camel.cloud.dns.service-discovery");
        }
    }
}

