/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.language.jq.JqLanguage;
import org.apache.camel.language.jq.springboot.JqLanguageConfiguration;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.LanguageConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={LanguageConfigurationProperties.class, JqLanguageConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.language", "camel.language.jq"})
public class JqLanguageAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private JqLanguageConfiguration configuration;

    public JqLanguageAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public LanguageCustomizer configureJqLanguage() {
        return new LanguageCustomizer(){

            public void configure(String name, Language target) {
                CamelPropertiesHelper.copyProperties((CamelContext)JqLanguageAutoConfiguration.this.camelContext, (Object)((Object)JqLanguageAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Language target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)JqLanguageAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.language.customizer", "camel.language.jq.customizer"}) && target instanceof JqLanguage;
            }
        };
    }
}

