/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.service.lra.springboot.LraServiceConfiguration;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={LraServiceConfiguration.class})
public class LraServiceAutoConfiguration {
    @Autowired
    private CamelContext camelContext;

    @Bean(name={"lra-service"})
    @ConditionalOnMissingBean(value={CamelSagaService.class})
    @ConditionalOnProperty(value={"camel.lra.enabled"}, havingValue="true")
    public LRASagaService configureLraSagaService(LraServiceConfiguration configuration) throws Exception {
        LRASagaService service = new LRASagaService();
        service.setCoordinatorUrl(configuration.getCoordinatorUrl());
        service.setCoordinatorContextPath(configuration.getCoordinatorContextPath());
        service.setLocalParticipantUrl(configuration.getLocalParticipantUrl());
        service.setLocalParticipantContextPath(configuration.getLocalParticipantContextPath());
        this.camelContext.addService((Object)service);
        return service;
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel", "camel.lra");
        }
    }
}

