/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamily
implements IColumnContainer,
IIterableColumns {
    private static Logger logger = LoggerFactory.getLogger(ColumnFamily.class);
    private static ColumnFamilySerializer serializer = new ColumnFamilySerializer();
    private final Integer cfid;
    private final ColumnFamilyType type;
    private transient ICompactSerializer2<IColumn> columnSerializer;
    final AtomicLong markedForDeleteAt = new AtomicLong(Long.MIN_VALUE);
    final AtomicInteger localDeletionTime = new AtomicInteger(Integer.MIN_VALUE);
    private ConcurrentSkipListMap<ByteBuffer, IColumn> columns;

    public static ColumnFamilySerializer serializer() {
        return serializer;
    }

    public static ColumnFamily create(Integer cfId) {
        return ColumnFamily.create(DatabaseDescriptor.getCFMetaData(cfId));
    }

    public static ColumnFamily create(String tableName, String cfName) {
        return ColumnFamily.create(DatabaseDescriptor.getCFMetaData(tableName, cfName));
    }

    public static ColumnFamily create(CFMetaData cfm) {
        assert (cfm != null);
        return new ColumnFamily(cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId);
    }

    public ColumnFamily(ColumnFamilyType type, AbstractType comparator, AbstractType subcolumnComparator, Integer cfid) {
        this.type = type;
        this.columnSerializer = type == ColumnFamilyType.Standard ? Column.serializer() : SuperColumn.serializer(subcolumnComparator);
        this.columns = new ConcurrentSkipListMap(comparator);
        this.cfid = cfid;
    }

    public ColumnFamily cloneMeShallow() {
        ColumnFamily cf = new ColumnFamily(this.type, this.getComparator(), this.getSubComparator(), this.cfid);
        cf.markedForDeleteAt.set(this.markedForDeleteAt.get());
        cf.localDeletionTime.set(this.localDeletionTime.get());
        return cf;
    }

    public AbstractType getSubComparator() {
        return this.columnSerializer instanceof SuperColumnSerializer ? ((SuperColumnSerializer)this.columnSerializer).getComparator() : null;
    }

    public ColumnFamilyType getColumnFamilyType() {
        return this.type;
    }

    public ColumnFamily cloneMe() {
        ColumnFamily cf = this.cloneMeShallow();
        cf.columns = this.columns.clone();
        return cf;
    }

    public Integer id() {
        return this.cfid;
    }

    public CFMetaData metadata() {
        return DatabaseDescriptor.getCFMetaData(this.cfid);
    }

    public void addAll(ColumnFamily cf) {
        for (IColumn column : cf.getSortedColumns()) {
            this.addColumn(column);
        }
        this.delete(cf);
    }

    public ICompactSerializer2<IColumn> getColumnSerializer() {
        return this.columnSerializer;
    }

    int getColumnCount() {
        return this.columns.size();
    }

    public boolean isSuper() {
        return this.type == ColumnFamilyType.Super;
    }

    public void addColumn(QueryPath path, ByteBuffer value, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new Column(path.columnName, value, timestamp));
    }

    public void addColumn(QueryPath path, ByteBuffer value, long timestamp, int timeToLive) {
        assert (path.columnName != null) : path;
        Column column = timeToLive > 0 ? new ExpiringColumn(path.columnName, value, timestamp, timeToLive) : new Column(path.columnName, value, timestamp);
        this.addColumn(path.superColumnName, column);
    }

    public void addTombstone(QueryPath path, ByteBuffer localDeletionTime, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new DeletedColumn(path.columnName, localDeletionTime, timestamp));
    }

    public void addTombstone(QueryPath path, int localDeletionTime, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new DeletedColumn(path.columnName, localDeletionTime, timestamp));
    }

    public void addTombstone(ByteBuffer name, int localDeletionTime, long timestamp) {
        this.addColumn(null, new DeletedColumn(name, localDeletionTime, timestamp));
    }

    public void addColumn(ByteBuffer superColumnName, Column column) {
        IColumn c;
        if (superColumnName == null) {
            c = column;
        } else {
            assert (this.isSuper());
            c = new SuperColumn(superColumnName, this.getSubComparator());
            c.addColumn(column);
        }
        this.addColumn(c);
    }

    public void clear() {
        this.columns.clear();
    }

    @Override
    public void addColumn(IColumn column) {
        ByteBuffer name = column.name();
        IColumn oldColumn = this.columns.putIfAbsent(name, column);
        if (oldColumn != null) {
            if (oldColumn instanceof SuperColumn) {
                ((SuperColumn)oldColumn).putColumn(column);
            } else {
                IColumn reconciledColumn = column.reconcile(oldColumn);
                while (!this.columns.replace(name, oldColumn, reconciledColumn)) {
                    oldColumn = this.columns.get(name);
                    reconciledColumn = column.reconcile(oldColumn);
                }
            }
        }
    }

    public IColumn getColumn(ByteBuffer name) {
        return this.columns.get(name);
    }

    public SortedSet<ByteBuffer> getColumnNames() {
        return this.columns.keySet();
    }

    public Collection<IColumn> getSortedColumns() {
        return this.columns.values();
    }

    public Collection<IColumn> getReverseSortedColumns() {
        return this.columns.descendingMap().values();
    }

    public Map<ByteBuffer, IColumn> getColumnsMap() {
        return this.columns;
    }

    public void remove(ByteBuffer columnName) {
        this.columns.remove(columnName);
    }

    @Deprecated
    public void delete(int localtime, long timestamp) {
        this.localDeletionTime.set(localtime);
        this.markedForDeleteAt.set(timestamp);
    }

    public void delete(ColumnFamily cf2) {
        FBUtilities.atomicSetMax(this.localDeletionTime, cf2.getLocalDeletionTime());
        FBUtilities.atomicSetMax(this.markedForDeleteAt, cf2.getMarkedForDeleteAt());
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.markedForDeleteAt.get() > Long.MIN_VALUE;
    }

    public ColumnFamily diff(ColumnFamily cfComposite) {
        ColumnFamily cfDiff = new ColumnFamily(cfComposite.type, this.getComparator(), this.getSubComparator(), cfComposite.id());
        if (cfComposite.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            cfDiff.delete(cfComposite.getLocalDeletionTime(), cfComposite.getMarkedForDeleteAt());
        }
        Map<ByteBuffer, IColumn> columns = cfComposite.getColumnsMap();
        for (Map.Entry<ByteBuffer, IColumn> entry : columns.entrySet()) {
            ByteBuffer cName = entry.getKey();
            IColumn columnInternal = this.columns.get(cName);
            IColumn columnExternal = entry.getValue();
            if (columnInternal == null) {
                cfDiff.addColumn(columnExternal);
                continue;
            }
            IColumn columnDiff = columnInternal.diff(columnExternal);
            if (columnDiff == null) continue;
            cfDiff.addColumn(columnDiff);
        }
        if (!cfDiff.getColumnsMap().isEmpty() || cfDiff.isMarkedForDelete()) {
            return cfDiff;
        }
        return null;
    }

    @Override
    public AbstractType getComparator() {
        return (AbstractType)this.columns.comparator();
    }

    int size() {
        int size = 0;
        for (IColumn column : this.columns.values()) {
            size += column.size();
        }
        return size;
    }

    public int hashCode() {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object o) {
        throw new RuntimeException("Not implemented.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFamily(");
        CFMetaData cfm = this.metadata();
        sb.append(cfm == null ? "<anonymous>" : cfm.cfName);
        if (this.isMarkedForDelete()) {
            sb.append(" -deleted at " + this.getMarkedForDeleteAt() + "-");
        }
        sb.append(" [").append(this.getComparator().getColumnsString(this.getSortedColumns())).append("])");
        return sb.toString();
    }

    public static ByteBuffer digest(ColumnFamily cf) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        if (cf != null) {
            cf.updateDigest(digest);
        }
        return ByteBuffer.wrap(digest.digest());
    }

    public void updateDigest(MessageDigest digest) {
        for (IColumn column : this.columns.values()) {
            column.updateDigest(digest);
        }
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.markedForDeleteAt.get();
    }

    public int getLocalDeletionTime() {
        return this.localDeletionTime.get();
    }

    public static AbstractType getComparatorFor(String table, String columnFamilyName, ByteBuffer superColumnName) {
        return superColumnName == null ? DatabaseDescriptor.getComparator(table, columnFamilyName) : DatabaseDescriptor.getSubComparator(table, columnFamilyName);
    }

    public static ColumnFamily diff(ColumnFamily cf1, ColumnFamily cf2) {
        if (cf1 == null) {
            return cf2;
        }
        return cf1.diff(cf2);
    }

    public static ColumnFamily resolve(ColumnFamily cf1, ColumnFamily cf2) {
        if (cf1 == null) {
            return cf2;
        }
        cf1.resolve(cf2);
        return cf1;
    }

    public void resolve(ColumnFamily cf) {
        if (cf == null) {
            return;
        }
        this.addAll(cf);
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.getColumnCount();
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.columns.values().iterator();
    }
}

