/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class DecoratedKey<T extends Token>
implements Comparable<DecoratedKey> {
    private static IPartitioner partitioner = StorageService.getPartitioner();
    public static final Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

        @Override
        public int compare(DecoratedKey o1, DecoratedKey o2) {
            return o1.compareTo(o2);
        }
    };
    public final T token;
    public final ByteBuffer key;

    public DecoratedKey(T token, ByteBuffer key) {
        assert (token != null);
        this.token = token;
        this.key = key;
    }

    public int hashCode() {
        return ((Token)this.token).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecoratedKey other = (DecoratedKey)obj;
        return ((Token)this.token).equals(other.token);
    }

    @Override
    public int compareTo(DecoratedKey other) {
        return ((Token)this.token).compareTo(other.token);
    }

    public boolean isEmpty() {
        return ((Token)this.token).equals(partitioner.getMinimumToken());
    }

    public String toString() {
        String keystring = this.key == null ? "null" : FBUtilities.bytesToHex(this.key);
        return "DecoratedKey(" + this.token + ", " + keystring + ")";
    }
}

