/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SSTableNamesIterator;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.utils.FBUtilities;

public class NamesQueryFilter
implements IFilter {
    public final SortedSet<ByteBuffer> columns;

    public NamesQueryFilter(SortedSet<ByteBuffer> columns) {
        this.columns = columns;
    }

    public NamesQueryFilter(ByteBuffer column) {
        this(FBUtilities.singleton(column));
    }

    @Override
    public IColumnIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey key, AbstractType comparator) {
        return Memtable.getNamesIterator(key, cf, this);
    }

    @Override
    public IColumnIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableNamesIterator(sstable, key, this.columns);
    }

    @Override
    public IColumnIterator getSSTableColumnIterator(CFMetaData metadata, FileDataInput file, DecoratedKey key) {
        return new SSTableNamesIterator(metadata, file, key, this.columns);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        for (IColumn column : superColumn.getSubColumns()) {
            if (this.columns.contains(column.name()) && QueryFilter.isRelevant(column, superColumn, gcBefore)) continue;
            superColumn.remove(column.name());
        }
        return superColumn;
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        while (reducedColumns.hasNext()) {
            IColumn column = reducedColumns.next();
            if (!QueryFilter.isRelevant(column, container, gcBefore)) continue;
            container.addColumn(column);
        }
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType comparator) {
        return QueryFilter.getColumnComparator(comparator);
    }
}

