/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;

public class Bounds
extends AbstractBounds {
    public Bounds(Token left, Token right) {
        this(left, right, StorageService.getPartitioner());
    }

    Bounds(Token left, Token right, IPartitioner partitioner) {
        super(left, right, partitioner);
        assert (left.compareTo(right) <= 0 || right.equals(partitioner.getMinimumToken())) : "[" + left + "," + right + "]";
    }

    @Override
    public boolean contains(Token token) {
        return Range.contains(this.left, this.right, token) || this.left.equals(token);
    }

    @Override
    public AbstractBounds createFrom(Token token) {
        return new Bounds(this.left, token);
    }

    @Override
    public List<AbstractBounds> unwrap() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Bounds)) {
            return false;
        }
        Bounds rhs = (Bounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "[" + this.left + "," + this.right + "]";
    }
}

