/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncResult
implements IAsyncResult {
    private static Logger logger = LoggerFactory.getLogger(AsyncResult.class);
    private byte[] result;
    private AtomicBoolean done = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private long startTime = System.currentTimeMillis();
    private InetAddress from;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(long timeout, TimeUnit tu) throws TimeoutException {
        this.lock.lock();
        try {
            boolean bVal = true;
            try {
                if (!this.done.get()) {
                    long overall_timeout = (timeout = TimeUnit.MILLISECONDS.convert(timeout, tu)) - (System.currentTimeMillis() - this.startTime);
                    bVal = overall_timeout > 0L && this.condition.await(overall_timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ex) {
                throw new AssertionError((Object)ex);
            }
            if (!bVal && !this.done.get()) {
                throw new TimeoutException("Operation timed out.");
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void result(Message response) {
        try {
            this.lock.lock();
            if (!this.done.get()) {
                this.from = response.getFrom();
                this.result = response.getMessageBody();
                this.done.set(true);
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        MessagingService.removeRegisteredCallback(response.getMessageId());
    }

    @Override
    public InetAddress getFrom() {
        return this.from;
    }
}

