/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.IExecutorMBean;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCInspector {
    private static final Logger logger = LoggerFactory.getLogger(GCInspector.class);
    static final long INTERVAL_IN_MS = 1000L;
    static final long MIN_DURATION = 200L;
    static final long MIN_DURATION_TPSTATS = 1000L;
    public static final GCInspector instance = new GCInspector();
    private HashMap<String, Long> gctimes = new HashMap();
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    List<Object> beans = new ArrayList<Object>();

    public GCInspector() {
        Class<?> gcBeanClass = null;
        try {
            gcBeanClass = Class.forName("com.sun.management.GarbageCollectorMXBean");
            Class.forName("com.sun.management.GcInfo");
        }
        catch (ClassNotFoundException ex) {
            logger.warn("Cannot load sun GC monitoring classes. GCInspector is disabled.");
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            for (ObjectName name : server.queryNames(gcName, null)) {
                Object gc = ManagementFactory.newPlatformMXBeanProxy(server, name.getCanonicalName(), gcBeanClass);
                this.beans.add(gc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        if (this.beans.size() == 0) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                GCInspector.this.logIntervalGCStats();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(t, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void logIntervalGCStats() {
        for (Object gc : this.beans) {
            Long previous;
            SunGcWrapper gcw = new SunGcWrapper(gc);
            if (gcw.isLastGcInfoNull() || (previous = this.gctimes.get(gcw.getName())) != null && previous.longValue() == gcw.getCollectionTime().longValue()) continue;
            this.gctimes.put(gcw.getName(), gcw.getCollectionTime());
            long previousMemoryUsed = 0L;
            long memoryUsed = 0L;
            long memoryMax = 0L;
            for (Map.Entry<String, MemoryUsage> entry : gcw.getMemoryUsageBeforeGc().entrySet()) {
                previousMemoryUsed += entry.getValue().getUsed();
            }
            for (Map.Entry<String, MemoryUsage> entry : gcw.getMemoryUsageAfterGc().entrySet()) {
                MemoryUsage mu = entry.getValue();
                memoryUsed += mu.getUsed();
                memoryMax += mu.getMax();
            }
            String st = String.format("GC for %s: %s ms, %s reclaimed leaving %s used; max is %s", gcw.getName(), gcw.getDuration(), previousMemoryUsed - memoryUsed, memoryUsed, memoryMax);
            if (gcw.getDuration() > 200L) {
                logger.info(st);
            } else if (logger.isDebugEnabled()) {
                logger.debug(st);
            }
            if (gcw.getDuration() <= 1000L) continue;
            this.logStats();
        }
    }

    public void logStats() {
        Set<ObjectName> internal;
        Set<ObjectName> request;
        logger.info(String.format("%-25s%10s%10s", "Pool Name", "Active", "Pending"));
        try {
            request = this.server.queryNames(new ObjectName("org.apache.cassandra.request:type=*"), null);
            internal = this.server.queryNames(new ObjectName("org.apache.cassandra.internal:type=*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (ObjectName objectName : Iterables.concat(request, internal)) {
            String poolName = objectName.getKeyProperty("type");
            IExecutorMBean threadPoolProxy = JMX.newMBeanProxy(this.server, objectName, IExecutorMBean.class);
            logger.info(String.format("%-25s%10s%10s", poolName, threadPoolProxy.getActiveCount(), threadPoolProxy.getPendingTasks()));
        }
        logger.info(String.format("%-25s%10s%10s", "CompactionManager", "n/a", CompactionManager.instance.getPendingTasks()));
        int pendingCommands = 0;
        for (int n : MessagingService.instance.getCommandPendingTasks().values()) {
            pendingCommands += n;
        }
        int pendingResponses = 0;
        Iterator<Object> i$ = MessagingService.instance.getResponsePendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            pendingResponses += n;
        }
        logger.info(String.format("%-25s%10s%10s", "MessagingService", "n/a", pendingCommands + "," + pendingResponses));
        logger.info(String.format("%-25s%20s%20s%20s", "ColumnFamily", "Memtable ops,data", "Row cache size/cap", "Key cache size/cap"));
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            logger.info(String.format("%-25s%20s%20s%20s", cfs.table.name + "." + cfs.columnFamily, cfs.getMemtableColumnsCount() + "," + cfs.getMemtableDataSize(), cfs.getRowCacheSize() + "/" + cfs.getRowCacheCapacity(), cfs.getKeyCacheSize() + "/" + cfs.getKeyCacheCapacity()));
        }
    }

    private static final class SunGcWrapper {
        private Map<String, MemoryUsage> usageBeforeGc = null;
        private Map<String, MemoryUsage> usageAfterGc = null;
        private String name;
        private Long collectionTime;
        private Long duration;

        SunGcWrapper(Object gcMxBean) {
            try {
                assert (Class.forName("com.sun.management.GarbageCollectorMXBean").isAssignableFrom(gcMxBean.getClass()));
                Method getGcInfo = gcMxBean.getClass().getDeclaredMethod("getLastGcInfo", new Class[0]);
                Object lastGcInfo = getGcInfo.invoke(gcMxBean, new Object[0]);
                if (lastGcInfo != null) {
                    this.usageBeforeGc = (Map)lastGcInfo.getClass().getDeclaredMethod("getMemoryUsageBeforeGc", new Class[0]).invoke(lastGcInfo, new Object[0]);
                    this.usageAfterGc = (Map)lastGcInfo.getClass().getDeclaredMethod("getMemoryUsageAfterGc", new Class[0]).invoke(lastGcInfo, new Object[0]);
                    this.duration = (Long)lastGcInfo.getClass().getDeclaredMethod("getDuration", new Class[0]).invoke(lastGcInfo, new Object[0]);
                    this.name = (String)gcMxBean.getClass().getDeclaredMethod("getName", new Class[0]).invoke(gcMxBean, new Object[0]);
                    this.collectionTime = (Long)gcMxBean.getClass().getDeclaredMethod("getCollectionTime", new Class[0]).invoke(gcMxBean, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        String getName() {
            return this.name;
        }

        Long getCollectionTime() {
            return this.collectionTime;
        }

        Long getDuration() {
            return this.duration;
        }

        Map<String, MemoryUsage> getMemoryUsageAfterGc() {
            return this.usageAfterGc;
        }

        Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
            return this.usageBeforeGc;
        }

        boolean isLastGcInfoNull() {
            return this.usageBeforeGc == null;
        }
    }
}

