/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTThreadPoolServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CustomTThreadPoolServer.class.getName());
    private ExecutorService executorService_;
    private volatile boolean stopped_;
    private Options options_;

    public CustomTThreadPoolServer(TProcessorFactory tProcessorFactory, TServerSocket tServerSocket, TTransportFactory inTransportFactory, TTransportFactory outTransportFactory, TProtocolFactory tProtocolFactory, TProtocolFactory tProtocolFactory2, Options options, ExecutorService executorService) {
        super(tProcessorFactory, (TServerTransport)tServerSocket, inTransportFactory, outTransportFactory, tProtocolFactory, tProtocolFactory2);
        this.options_ = options;
        this.executorService_ = executorService;
    }

    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", (Throwable)ttx);
            return;
        }
        this.stopped_ = false;
        while (!this.stopped_) {
            int failureCount = 0;
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                this.executorService_.execute(wp);
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn("Transport error occurred during acceptance of message.", (Throwable)ttx);
            }
        }
        this.executorService_.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.options_.stopTimeoutUnit.toMillis(this.options_.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        @Override
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            try {
                processor = CustomTThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = CustomTThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = CustomTThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = CustomTThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = CustomTThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                while (!CustomTThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol)) {
                    inputProtocol = CustomTThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                    outputProtocol = CustomTThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                }
            }
            catch (TTransportException ttx) {
            }
            catch (TException tx) {
                LOGGER.error("Thrift error occurred during processing of message.", (Throwable)tx);
            }
            catch (Exception x) {
                LOGGER.error("Error occurred during processing of message.", (Throwable)x);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }

    public static class Options {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
    }
}

