/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipDigestAckVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(GossipDigestAckVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        InetAddress from = message.getFrom();
        if (logger_.isTraceEnabled()) {
            logger_.trace("Received a GossipDigestAckMessage from {}", (Object)from);
        }
        if (!Gossiper.instance.isEnabled()) {
            if (logger_.isTraceEnabled()) {
                logger_.trace("Ignoring GossipDigestAckMessage because gossip is disabled");
            }
            return;
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            GossipDigestAckMessage gDigestAckMessage = GossipDigestAckMessage.serializer().deserialize(dis);
            List<GossipDigest> gDigestList = gDigestAckMessage.getGossipDigestList();
            Map<InetAddress, EndpointState> epStateMap = gDigestAckMessage.getEndpointStateMap();
            if (epStateMap.size() > 0) {
                Gossiper.instance.notifyFailureDetector(epStateMap);
                Gossiper.instance.applyStateLocally(epStateMap);
            }
            HashMap<InetAddress, EndpointState> deltaEpStateMap = new HashMap<InetAddress, EndpointState>();
            for (GossipDigest gDigest : gDigestList) {
                InetAddress addr = gDigest.getEndpoint();
                EndpointState localEpStatePtr = Gossiper.instance.getStateForVersionBiggerThan(addr, gDigest.getMaxVersion());
                if (localEpStatePtr == null) continue;
                deltaEpStateMap.put(addr, localEpStatePtr);
            }
            GossipDigestAck2Message gDigestAck2 = new GossipDigestAck2Message(deltaEpStateMap);
            Message gDigestAck2Message = Gossiper.instance.makeGossipDigestAck2Message(gDigestAck2);
            if (logger_.isTraceEnabled()) {
                logger_.trace("Sending a GossipDigestAck2Message to {}", (Object)from);
            }
            MessagingService.instance().sendOneWay(gDigestAck2Message, from);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

