/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.obs.OpenBitSet;

class BloomFilterSerializer
implements ICompactSerializer<BloomFilter> {
    BloomFilterSerializer() {
    }

    @Override
    public void serialize(BloomFilter bf, DataOutputStream dos) throws IOException {
        long[] bits = bf.bitset.getBits();
        int bitLength = bits.length;
        dos.writeInt(bf.getHashCount());
        dos.writeInt(bitLength);
        for (int i = 0; i < bitLength; ++i) {
            dos.writeLong(bits[i]);
        }
        dos.flush();
    }

    @Override
    public BloomFilter deserialize(DataInputStream dis) throws IOException {
        int hashes = dis.readInt();
        int bitLength = dis.readInt();
        long[] bits = new long[bitLength];
        for (int i = 0; i < bitLength; ++i) {
            bits[i] = dis.readLong();
        }
        OpenBitSet bs = new OpenBitSet(bits, bitLength);
        return new BloomFilter(hashes, bs);
    }
}

