/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.ByteBufferInputStream;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.io.util.OutputBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class SerDeUtils {
    private static final DecoderFactory DIRECT_DECODERS = new DecoderFactory().configureDirectDecoder(true);

    public static <T extends SpecificRecord> T deserialize(Schema writer, ByteBuffer bytes, T ob) throws IOException {
        BinaryDecoder dec = DIRECT_DECODERS.createBinaryDecoder(ByteBufferUtil.getArray(bytes), null);
        SpecificDatumReader reader = new SpecificDatumReader(writer);
        reader.setExpected(ob.getSchema());
        return (T)((SpecificRecord)reader.read(ob, (Decoder)dec));
    }

    public static <T extends SpecificRecord> ByteBuffer serialize(T o) throws IOException {
        OutputBuffer buff = new OutputBuffer();
        BinaryEncoder enc = new BinaryEncoder((OutputStream)buff);
        SpecificDatumWriter writer = new SpecificDatumWriter(o.getSchema());
        writer.write(o, (Encoder)enc);
        enc.flush();
        return ByteBuffer.wrap(buff.asByteArray());
    }

    public static <T extends SpecificRecord> T deserializeWithSchema(ByteBuffer bytes, T ob) throws IOException {
        BinaryDecoder dec = DIRECT_DECODERS.createBinaryDecoder(ByteBufferUtil.getArray(bytes), null);
        Schema writer = Schema.parse((String)dec.readString(new Utf8()).toString());
        SpecificDatumReader reader = new SpecificDatumReader(writer);
        reader.setExpected(ob.getSchema());
        return (T)((SpecificRecord)reader.read(ob, (Decoder)dec));
    }

    public static <T extends SpecificRecord> ByteBuffer serializeWithSchema(T o) throws IOException {
        OutputBuffer buff = new OutputBuffer();
        BinaryEncoder enc = new BinaryEncoder((OutputStream)buff);
        enc.writeString(new Utf8(o.getSchema().toString()));
        SpecificDatumWriter writer = new SpecificDatumWriter(o.getSchema());
        writer.write(o, (Encoder)enc);
        enc.flush();
        return ByteBuffer.wrap(buff.asByteArray());
    }

    public static DataInputStream createDataInputStream(ByteBuffer buff) {
        ByteBufferInputStream bbis = new ByteBufferInputStream(Collections.singletonList(buff));
        return new DataInputStream((InputStream)bbis);
    }

    public static <T> GenericArray<T> createArray(int size, Schema schema) {
        return new GenericData.Array(size, Schema.createArray((Schema)schema));
    }
}

