/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql.Relation;
import org.apache.cassandra.cql.RelationType;
import org.apache.cassandra.cql.Term;

public class WhereClause {
    private List<Term> keys = new ArrayList<Term>();
    private Term startKey;
    private Term finishKey;
    private List<Relation> columns = new ArrayList<Relation>();

    public WhereClause(Relation firstRelation) {
        this.and(firstRelation);
    }

    public WhereClause() {
    }

    public void and(Relation relation) {
        if (relation.isKey()) {
            if (relation.operator().equals((Object)RelationType.EQ)) {
                this.keys.add(relation.getValue());
            } else if (relation.operator().equals((Object)RelationType.GT) || relation.operator().equals((Object)RelationType.GTE)) {
                this.startKey = relation.getValue();
            } else if (relation.operator().equals((Object)RelationType.LT) || relation.operator().equals((Object)RelationType.LTE)) {
                this.finishKey = relation.getValue();
            }
        } else {
            this.columns.add(relation);
        }
    }

    public List<Relation> getColumnRelations() {
        return this.columns;
    }

    public boolean isKeyRange() {
        return this.startKey != null;
    }

    public boolean isKeyList() {
        return !this.isKeyRange();
    }

    public Term getStartKey() {
        return this.startKey;
    }

    public Term getFinishKey() {
        return this.finishKey;
    }

    public List<Term> getKeys() {
        return this.keys;
    }
}

