/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.cassandra.utils.AbstractStatsDeque;

class AdaptiveLatencyTracker
extends AbstractStatsDeque {
    private final LinkedBlockingDeque<Double> latencies;
    private static final double SENTINEL_COMPARE = 1.0E-4;

    AdaptiveLatencyTracker(int size) {
        this.latencies = new LinkedBlockingDeque(size);
    }

    @Override
    public void add(double i) {
        if (!this.latencies.offer(i)) {
            this.latencies.remove();
            this.latencies.offer(i);
        }
    }

    @Override
    public void clear() {
        this.latencies.clear();
    }

    @Override
    public Iterator<Double> iterator() {
        return this.latencies.iterator();
    }

    @Override
    public int size() {
        return this.latencies.size();
    }

    double p(double t) {
        double mean = this.mean();
        double exponent = -1.0 * t / mean;
        return 1.0 - Math.pow(Math.E, exponent);
    }

    double score() {
        double log = 0.0;
        if (this.latencies.size() > 0) {
            double probability = this.p(1.0E-4);
            log = -1.0 * Math.log10(probability);
        }
        return log;
    }
}

