/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class OldNetworkTopologyStrategy
extends AbstractReplicationStrategy {
    public OldNetworkTopologyStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(table, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        Token t;
        int replicas = this.getReplicationFactor();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        ArrayList<Token> tokens = metadata.sortedTokens();
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token, false);
        Token primaryToken = iter.next();
        endpoints.add(metadata.getEndpoint(primaryToken));
        boolean bDataCenter = false;
        boolean bOtherRack = false;
        while (endpoints.size() < replicas && iter.hasNext()) {
            t = iter.next();
            if (!this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t)))) {
                if (bDataCenter) continue;
                endpoints.add(metadata.getEndpoint(t));
                bDataCenter = true;
                continue;
            }
            if (this.snitch.getRack(metadata.getEndpoint(primaryToken)).equals(this.snitch.getRack(metadata.getEndpoint(t))) || !this.snitch.getDatacenter(metadata.getEndpoint(primaryToken)).equals(this.snitch.getDatacenter(metadata.getEndpoint(t))) || bOtherRack) continue;
            endpoints.add(metadata.getEndpoint(t));
            bOtherRack = true;
        }
        if (endpoints.size() < replicas) {
            iter = TokenMetadata.ringIterator(tokens, token, false);
            while (endpoints.size() < replicas && iter.hasNext()) {
                t = iter.next();
                if (endpoints.contains(metadata.getEndpoint(t))) continue;
                endpoints.add(metadata.getEndpoint(t));
            }
            if (endpoints.size() < replicas) {
                throw new IllegalStateException(String.format("replication factor (%s) exceeds number of endpoints (%s)", replicas, endpoints.size()));
            }
        }
        return endpoints;
    }

    @Override
    public int getReplicationFactor() {
        return Integer.parseInt((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        if (this.configOptions == null) {
            throw new ConfigurationException("OldNetworkTopologyStrategy requires a replication_factor strategy option.");
        }
        if (this.configOptions.get("replication_factor") == null) {
            throw new ConfigurationException("OldNetworkTopologyStrategy requires a replication_factor strategy option.");
        }
        int rf = Integer.parseInt((String)this.configOptions.get("replication_factor"));
        if (rf < 0) {
            throw new ConfigurationException("Replication factor for OldNetworkTopologyStrategy must be non-negative, " + rf + " given.");
        }
    }
}

