/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ResourceWatcher;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileSnitch.class);
    private static final String RACK_PROPERTY_FILENAME = "cassandra-topology.properties";
    private static volatile Map<InetAddress, String[]> endpointMap;
    private static volatile String[] defaultDCRack;

    public PropertyFileSnitch() throws ConfigurationException {
        this.reloadConfiguration();
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws ConfigurationException {
                PropertyFileSnitch.this.reloadConfiguration();
            }
        };
        ResourceWatcher.watch(RACK_PROPERTY_FILENAME, runnable, 60000);
    }

    public String[] getEndpointInfo(InetAddress endpoint) {
        String[] value = endpointMap.get(endpoint);
        if (value == null) {
            logger.debug("Could not find end point information for {}, will use default", (Object)endpoint);
            return defaultDCRack;
        }
        return value;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        return this.getEndpointInfo(endpoint)[0];
    }

    @Override
    public String getRack(InetAddress endpoint) {
        return this.getEndpointInfo(endpoint)[1];
    }

    public void reloadConfiguration() throws ConfigurationException {
        HashMap<InetAddress, String[]> reloadedMap = new HashMap<InetAddress, String[]>();
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(RACK_PROPERTY_FILENAME);
            properties.load(stream);
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException("Unable to read cassandra-topology.properties", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(stream);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            InetAddress host;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("default")) {
                defaultDCRack = value.split(":");
                if (defaultDCRack.length >= 2) continue;
                defaultDCRack = new String[]{"default", "default"};
                continue;
            }
            String hostString = key.replace("/", "");
            try {
                host = InetAddress.getByName(hostString);
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Unknown host " + hostString, e);
            }
            String[] token = value.split(":");
            if (token.length < 2) {
                token = new String[]{"default", "default"};
            }
            reloadedMap.put(host, token);
        }
        logger.debug("loaded network topology {}", (Object)FBUtilities.toString(reloadedMap));
        endpointMap = reloadedMap;
        StorageService.instance.getTokenMetadata().invalidateCaches();
    }
}

