/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.Relation;
import org.apache.cassandra.cql.SelectExpression;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.cql.WhereClause;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.thrift.ConsistencyLevel;

public class SelectStatement {
    private final SelectExpression expression;
    private final boolean isCountOper;
    private final String columnFamily;
    private final ConsistencyLevel cLevel;
    private final WhereClause clause;
    private final int numRecords;

    public SelectStatement(SelectExpression expression, boolean isCountOper, String columnFamily, ConsistencyLevel cLevel, WhereClause clause, int numRecords) {
        this.expression = expression;
        this.isCountOper = isCountOper;
        this.columnFamily = columnFamily;
        this.cLevel = cLevel;
        this.clause = clause != null ? clause : new WhereClause();
        this.numRecords = numRecords;
    }

    public boolean isKeyRange() {
        return this.clause.isKeyRange();
    }

    public Set<Term> getKeys() {
        return this.clause.getKeys();
    }

    public Term getKeyStart() {
        return this.clause.getStartKey();
    }

    public Term getKeyFinish() {
        return this.clause.getFinishKey();
    }

    public List<Relation> getColumnRelations() {
        return this.clause.getColumnRelations();
    }

    public boolean isColumnRange() {
        return this.expression.isColumnRange();
    }

    public boolean isWildcard() {
        return this.expression.isWildcard();
    }

    public List<Term> getColumnNames() {
        return this.expression.getColumns();
    }

    public Term getColumnStart() {
        return this.expression.getStart();
    }

    public Term getColumnFinish() {
        return this.expression.getFinish();
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public boolean isColumnsReversed() {
        return this.expression.isColumnsReversed();
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.cLevel;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getColumnsLimit() {
        return this.expression.getColumnsLimit();
    }

    public boolean isCountOperation() {
        return this.isCountOper;
    }

    public boolean includeStartKey() {
        return this.clause.includeStartKey();
    }

    public boolean includeFinishKey() {
        return this.clause.includeFinishKey();
    }

    public String getKeyAlias() {
        return this.clause.getKeyAlias();
    }

    public boolean isMultiKey() {
        return this.clause.isMultiKey();
    }

    public void extractKeyAliasFromColumns(CFMetaData cfm) {
        this.clause.extractKeysFromColumns(cfm);
    }

    public AbstractType getComparator(String keyspace) {
        return Schema.instance.getComparator(keyspace, this.columnFamily);
    }

    public AbstractType getValueValidator(String keyspace, ByteBuffer column) {
        return Schema.instance.getValueValidator(keyspace, this.columnFamily, column);
    }
}

