/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class CompressedSegmentedFile
extends SegmentedFile {
    private final CompressionMetadata metadata;

    public CompressedSegmentedFile(String path, CompressionMetadata metadata) {
        super(path, metadata.dataLength);
        this.metadata = metadata;
    }

    @Override
    public FileDataInput getSegment(long position) {
        try {
            RandomAccessReader file = CompressedRandomAccessReader.open(this.path, this.metadata);
            file.seek(position);
            return file;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void cleanup() {
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            return new CompressedSegmentedFile(path, CompressedRandomAccessReader.metadata(path));
        }
    }
}

