/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowResolver
implements IResponseResolver<Row> {
    protected static Logger logger = LoggerFactory.getLogger(AbstractRowResolver.class);
    private static final Message FAKE_MESSAGE = new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.INTERNAL_RESPONSE, ArrayUtils.EMPTY_BYTE_ARRAY, -1);
    protected final String table;
    protected final ConcurrentMap<Message, ReadResponse> replies = new NonBlockingHashMap();
    protected final DecoratedKey<?> key;

    public AbstractRowResolver(ByteBuffer key, String table) {
        this.key = StorageService.getPartitioner().decorateKey(key);
        this.table = table;
    }

    @Override
    public void preprocess(Message message) {
        byte[] body = message.getMessageBody();
        FastByteArrayInputStream bufIn = new FastByteArrayInputStream(body);
        try {
            ReadResponse result = ReadResponse.serializer().deserialize(new DataInputStream(bufIn), message.getVersion());
            if (logger.isDebugEnabled()) {
                logger.debug("Preprocessed {} response", (Object)(result.isDigestQuery() ? "digest" : "data"));
            }
            this.replies.put(message, result);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void injectPreProcessed(ReadResponse result) {
        assert (this.replies.get(FAKE_MESSAGE) == null);
        this.replies.put(FAKE_MESSAGE, result);
    }

    @Override
    public Iterable<Message> getMessages() {
        return this.replies.keySet();
    }

    @Override
    public int getMaxLiveColumns() {
        throw new UnsupportedOperationException();
    }
}

