/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecompactedRow
extends AbstractCompactedRow {
    private static Logger logger = LoggerFactory.getLogger(PrecompactedRow.class);
    private final ColumnFamily compactedCf;

    public PrecompactedRow(DecoratedKey<?> key, ColumnFamily cf) {
        super(key);
        this.compactedCf = cf;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey<?> key, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted;
        assert (key != null);
        assert (controller != null);
        assert (cf != null);
        Boolean shouldPurge = null;
        if (cf.hasIrrelevantData(controller.gcBefore)) {
            shouldPurge = controller.shouldPurge(key);
        }
        ColumnFamily columnFamily = compacted = shouldPurge != null && shouldPurge != false ? ColumnFamilyStore.removeDeleted(cf, controller.gcBefore) : cf;
        if (compacted != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            if (shouldPurge == null) {
                shouldPurge = controller.shouldPurge(key);
            }
            if (shouldPurge.booleanValue()) {
                CounterColumn.mergeAndRemoveOldShards(key, compacted, controller.gcBefore, controller.mergeShardBefore);
            }
        }
        return compacted;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey key, boolean shouldPurge, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted;
        ColumnFamily columnFamily = compacted = shouldPurge ? ColumnFamilyStore.removeDeleted(cf, controller.gcBefore) : cf;
        if (shouldPurge && compacted != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            CounterColumn.mergeAndRemoveOldShards(key, compacted, controller.gcBefore, controller.mergeShardBefore);
        }
        return compacted;
    }

    public PrecompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        this(rows.get(0).getKey(), PrecompactedRow.removeDeletedAndOldShards(rows.get(0).getKey(), controller, PrecompactedRow.merge(rows)));
    }

    private static ColumnFamily merge(List<SSTableIdentityIterator> rows) {
        assert (!rows.isEmpty());
        ColumnFamily cf = null;
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily thisCF;
            try {
                thisCF = row.getColumnFamilyWithColumns();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            if (cf == null) {
                cf = thisCF;
                continue;
            }
            cf.addAll(thisCF, HeapAllocator.instance);
        }
        return cf;
    }

    @Override
    public long write(DataOutput out) throws IOException {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        DataOutputBuffer headerBuffer = new DataOutputBuffer();
        ColumnIndexer.serialize(this.compactedCf, (DataOutput)headerBuffer);
        ColumnFamily.serializer().serializeForSSTable(this.compactedCf, buffer);
        int dataSize = headerBuffer.getLength() + buffer.getLength();
        out.writeLong(dataSize);
        out.write(headerBuffer.getData(), 0, headerBuffer.getLength());
        out.write(buffer.getData(), 0, buffer.getLength());
        return dataSize;
    }

    @Override
    public void update(MessageDigest digest) {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            ColumnFamily.serializer().serializeCFInfo(this.compactedCf, buffer);
            buffer.writeInt(this.compactedCf.getColumnCount());
            digest.update(buffer.getData(), 0, buffer.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.compactedCf.updateDigest(digest);
    }

    @Override
    public boolean isEmpty() {
        return this.compactedCf == null;
    }

    @Override
    public int columnCount() {
        return this.compactedCf == null ? 0 : this.compactedCf.getColumnCount();
    }

    @Override
    public long maxTimestamp() {
        return this.compactedCf.maxTimestamp();
    }

    public ColumnFamily getFullColumnFamily() throws IOException {
        return this.compactedCf;
    }
}

