/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptedBlockException;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedRandomAccessReader
extends RandomAccessReader {
    private static final Logger logger = LoggerFactory.getLogger(CompressedRandomAccessReader.class);
    private final CompressionMetadata metadata;
    private byte[] compressed;
    private final Checksum checksum = new CRC32();
    private final byte[] checksumBytes = new byte[4];
    private final FileInputStream source;
    private final FileChannel channel;

    public static RandomAccessReader open(String dataFilePath, CompressionMetadata metadata) throws IOException {
        return CompressedRandomAccessReader.open(dataFilePath, metadata, false);
    }

    public static RandomAccessReader open(String dataFilePath, CompressionMetadata metadata, boolean skipIOCache) throws IOException {
        return new CompressedRandomAccessReader(dataFilePath, metadata, skipIOCache);
    }

    public CompressedRandomAccessReader(String dataFilePath, CompressionMetadata metadata, boolean skipIOCache) throws IOException {
        super(new File(dataFilePath), metadata.chunkLength(), skipIOCache);
        this.metadata = metadata;
        this.compressed = new byte[metadata.compressor().initialCompressedBufferLength(metadata.chunkLength())];
        this.source = new FileInputStream(this.getFD());
        this.channel = this.source.getChannel();
    }

    @Override
    protected void reBuffer() throws IOException {
        this.decompressChunk(this.metadata.chunkFor(this.current));
    }

    private void decompressChunk(CompressionMetadata.Chunk chunk) throws IOException {
        if (this.channel.position() != chunk.offset) {
            this.channel.position(chunk.offset);
        }
        if (this.compressed.length < chunk.length) {
            this.compressed = new byte[chunk.length];
        }
        if (this.source.read(this.compressed, 0, chunk.length) != chunk.length) {
            throw new IOException(String.format("(%s) failed to read %d bytes from offset %d.", this.getPath(), chunk.length, chunk.offset));
        }
        this.validBufferBytes = this.metadata.compressor().uncompress(this.compressed, 0, chunk.length, this.buffer, 0);
        this.checksum.update(this.buffer, 0, this.validBufferBytes);
        if (this.checksum(chunk) != (int)this.checksum.getValue()) {
            throw new CorruptedBlockException(this.getPath(), chunk);
        }
        this.checksum.reset();
        this.bufferOffset = this.current & (long)(~(this.buffer.length - 1));
    }

    private int checksum(CompressionMetadata.Chunk chunk) throws IOException {
        assert (this.channel.position() == chunk.offset + (long)chunk.length);
        if (this.source.read(this.checksumBytes, 0, this.checksumBytes.length) != this.checksumBytes.length) {
            throw new IOException(String.format("(%s) failed to read checksum of the chunk at %d of length %d.", this.getPath(), chunk.offset, chunk.length));
        }
        return FBUtilities.byteArrayToInt(this.checksumBytes);
    }

    @Override
    public long length() throws IOException {
        return this.metadata.dataLength;
    }

    @Override
    public String toString() {
        return String.format("%s - chunk length %d, data length %d.", this.getPath(), this.metadata.chunkLength(), this.metadata.dataLength);
    }
}

