/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.SnappyCompressor;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CFMetaData {
    private static Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.1;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.0;
    public static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final double DEFAULT_MERGE_SHARDS_CHANCE = 0.1;
    public static final String DEFAULT_COMPACTION_STRATEGY_CLASS = "SizeTieredCompactionStrategy";
    public static final ByteBuffer DEFAULT_KEY_NAME = ByteBufferUtil.bytes("KEY");
    public static final CFMetaData StatusCf = CFMetaData.newSystemMetadata("LocationInfo", 0, "persistent metadata for the local node", BytesType.instance, null);
    public static final CFMetaData HintsCf = CFMetaData.newSystemMetadata("HintsColumnFamily", 1, "hinted handoff data", BytesType.instance, BytesType.instance);
    @Deprecated
    public static final CFMetaData MigrationsCf = CFMetaData.newSystemMetadata("Migrations", 2, "individual schema mutations", TimeUUIDType.instance, null);
    @Deprecated
    public static final CFMetaData SchemaCf = CFMetaData.newSystemMetadata("Schema", 3, "current state of the schema", UTF8Type.instance, null);
    public static final CFMetaData IndexCf = CFMetaData.newSystemMetadata("IndexInfo", 5, "indexes that have been completed", UTF8Type.instance, null);
    public static final CFMetaData NodeIdCf = CFMetaData.newSystemMetadata("NodeIdInfo", 6, "nodeId and their metadata", TimeUUIDType.instance, null);
    public static final CFMetaData VersionCf = CFMetaData.newSystemMetadata("Versions", 7, "server version information", UTF8Type.instance, null).keyAlias(ByteBufferUtil.bytes("component")).keyValidator(UTF8Type.instance).columnMetadata(Collections.singletonMap(ByteBufferUtil.bytes("version"), new ColumnDefinition(ByteBufferUtil.bytes("version"), UTF8Type.instance, null, null, null)));
    public static final CFMetaData SchemaKeyspacesCf = CFMetaData.schemaCFDefinition("schema_keyspaces", 8, "keyspace attributes of the schema", AsciiType.instance, 1);
    public static final CFMetaData SchemaColumnFamiliesCf = CFMetaData.schemaCFDefinition("schema_columnfamilies", 9, "ColumnFamily attributes of the schema", AsciiType.instance, 2);
    public static final CFMetaData SchemaColumnsCf = CFMetaData.schemaCFDefinition("schema_columns", 10, "ColumnFamily column attributes of the schema", AsciiType.instance, 3);
    public final Integer cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public AbstractType<?> comparator;
    public AbstractType<?> subcolumnComparator;
    private String comment;
    private double readRepairChance;
    private double dcLocalReadRepairChance;
    private boolean replicateOnWrite;
    private int gcGraceSeconds;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private int minCompactionThreshold;
    private int maxCompactionThreshold;
    private double mergeShardsChance;
    private ByteBuffer keyAlias;
    private List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private Double bloomFilterFpChance;
    private Caching caching;
    private Map<ByteBuffer, ColumnDefinition> column_metadata;
    public Class<? extends AbstractCompactionStrategy> compactionStrategyClass;
    public Map<String, String> compactionStrategyOptions;
    private CompressionParameters compressionParameters;
    private CFDefinition cqlCfDef;

    private static CFMetaData schemaCFDefinition(String name, int index, String comment, AbstractType<?> comp, int nestingLevel) {
        CompositeType comparator;
        if (nestingLevel == 1) {
            comparator = comp;
        } else {
            ArrayList composite = new ArrayList(nestingLevel);
            for (int i = 0; i < nestingLevel; ++i) {
                composite.add(comp);
            }
            comparator = CompositeType.getInstance(composite);
        }
        return CFMetaData.newSystemMetadata(name, index, comment, comparator, null).keyValidator(AsciiType.instance).defaultValidator(UTF8Type.instance);
    }

    public CFMetaData comment(String prop) {
        this.comment = CFMetaData.enforceCommentNotNull(prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dclocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData replicateOnWrite(boolean prop) {
        this.replicateOnWrite = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType<?> prop) {
        this.defaultValidator = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData keyValidator(AbstractType<?> prop) {
        this.keyValidator = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData mergeShardsChance(double prop) {
        this.mergeShardsChance = prop;
        return this;
    }

    public CFMetaData keyAlias(ByteBuffer prop) {
        this.keyAlias = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData columnAliases(List<ByteBuffer> prop) {
        this.columnAliases = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData valueAlias(ByteBuffer prop) {
        this.valueAlias = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData columnMetadata(Map<ByteBuffer, ColumnDefinition> prop) {
        this.column_metadata = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(Double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(Caching prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc) {
        this(keyspace, name, type, comp, subcc, Schema.instance.nextCFId());
    }

    private CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc, int id) {
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
        this.subcolumnComparator = this.enforceSubccDefault(type, subcc);
        this.cfId = id;
        this.caching = Caching.KEYS_ONLY;
        this.init();
    }

    private AbstractType<?> enforceSubccDefault(ColumnFamilyType cftype, AbstractType<?> subcc) {
        return subcc == null && cftype == ColumnFamilyType.Super ? BytesType.instance : subcc;
    }

    private static String enforceCommentNotNull(CharSequence comment) {
        return comment == null ? "" : ((Object)comment).toString();
    }

    private void init() {
        this.readRepairChance = 0.1;
        this.dcLocalReadRepairChance = 0.0;
        this.replicateOnWrite = true;
        this.gcGraceSeconds = 864000;
        this.minCompactionThreshold = 4;
        this.maxCompactionThreshold = 32;
        this.mergeShardsChance = 0.1;
        this.defaultValidator = BytesType.instance;
        this.keyValidator = BytesType.instance;
        this.comment = "";
        this.keyAlias = null;
        this.valueAlias = null;
        this.column_metadata = new HashMap<ByteBuffer, ColumnDefinition>();
        try {
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(DEFAULT_COMPACTION_STRATEGY_CLASS);
        }
        catch (ConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        this.compactionStrategyOptions = new HashMap<String, String>();
        this.compressionParameters = new CompressionParameters(null);
        this.updateCfDef();
    }

    private static CFMetaData newSystemMetadata(String cfName, int cfId, String comment, AbstractType<?> comparator, AbstractType<?> subcc) {
        ColumnFamilyType type = subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super;
        CFMetaData newCFMD = new CFMetaData("system", cfName, type, comparator, subcc, cfId);
        return newCFMD.comment(comment).readRepairChance(0.0).dclocalReadRepairChance(0.0).gcGraceSeconds(0).mergeShardsChance(0.0);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, AbstractType<?> columnComparator) {
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, columnComparator, null).keyValidator(info.getValidator()).readRepairChance(0.0).dclocalReadRepairChance(0.0).reloadSecondaryIndexMetadata(parent);
    }

    public CFMetaData reloadSecondaryIndexMetadata(CFMetaData parent) {
        this.gcGraceSeconds(parent.gcGraceSeconds);
        this.minCompactionThreshold(parent.minCompactionThreshold);
        this.maxCompactionThreshold(parent.maxCompactionThreshold);
        this.compactionStrategyClass(parent.compactionStrategyClass);
        this.compactionStrategyOptions(parent.compactionStrategyOptions);
        this.compressionParameters(parent.compressionParameters);
        return this;
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return CFMetaData.copyOpts(new CFMetaData(cfm.ksName, newName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    public static CFMetaData renameTable(CFMetaData cfm, String ksName) {
        return CFMetaData.copyOpts(new CFMetaData(ksName, cfm.cfName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    private static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        return newCFMD.comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dclocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).replicateOnWrite(oldCFMD.replicateOnWrite).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).columnMetadata(oldCFMD.column_metadata).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(oldCFMD.compactionStrategyOptions).compressionParameters(oldCFMD.compressionParameters).bloomFilterFpChance(oldCFMD.bloomFilterFpChance).caching(oldCFMD.caching);
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + '.' + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    @Deprecated
    public static CFMetaData fromAvro(CfDef cf) {
        Caching caching;
        CompressionParameters cp;
        AbstractType<?> keyValidator;
        AbstractType<?> validator;
        AbstractType<?> comparator;
        AbstractType<?> subcolumnComparator = null;
        try {
            comparator = TypeParser.parse(((Object)cf.comparator_type).toString());
            if (cf.subcomparator_type != null) {
                subcolumnComparator = TypeParser.parse(cf.subcomparator_type);
            }
            validator = TypeParser.parse(cf.default_validation_class);
            keyValidator = TypeParser.parse(cf.key_validation_class);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not inflate CFMetaData for " + (Object)((Object)cf), ex);
        }
        TreeMap<ByteBuffer, ColumnDefinition> column_metadata = new TreeMap<ByteBuffer, ColumnDefinition>(BytesType.instance);
        for (ColumnDef aColumn_metadata : cf.column_metadata) {
            ColumnDefinition cd = ColumnDefinition.fromAvro(aColumn_metadata);
            if (cd.getIndexType() != null && cd.getIndexName() == null) {
                cd.setIndexName(CFMetaData.getDefaultIndexName(((Object)cf.name).toString(), comparator, cd.name));
            }
            column_metadata.put(cd.name, cd);
        }
        CFMetaData newCFMD = new CFMetaData(((Object)cf.keyspace).toString(), ((Object)cf.name).toString(), ColumnFamilyType.create(((Object)cf.column_type).toString()), comparator, subcolumnComparator, cf.id);
        if (cf.min_compaction_threshold != null) {
            newCFMD.minCompactionThreshold(cf.min_compaction_threshold);
        }
        if (cf.max_compaction_threshold != null) {
            newCFMD.maxCompactionThreshold(cf.max_compaction_threshold);
        }
        if (cf.merge_shards_chance != null) {
            newCFMD.mergeShardsChance(cf.merge_shards_chance);
        }
        if (cf.key_alias != null) {
            newCFMD.keyAlias(cf.key_alias);
        }
        if (cf.column_aliases != null) {
            newCFMD.columnAliases(CFMetaData.fixAvroRetardation(cf.column_aliases));
        }
        if (cf.value_alias != null) {
            newCFMD.valueAlias(cf.value_alias);
        }
        if (cf.compaction_strategy != null) {
            try {
                newCFMD.compactionStrategyClass = CFMetaData.createCompactionStrategy(((Object)cf.compaction_strategy).toString());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (cf.compaction_strategy_options != null) {
            for (Map.Entry<CharSequence, CharSequence> e : cf.compaction_strategy_options.entrySet()) {
                newCFMD.compactionStrategyOptions.put(((Object)e.getKey()).toString(), ((Object)e.getValue()).toString());
            }
        }
        try {
            cp = CompressionParameters.create(cf.compression_options);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            caching = cf.caching == null ? Caching.KEYS_ONLY : Caching.fromString(((Object)cf.caching).toString());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return newCFMD.comment(((Object)cf.comment).toString()).readRepairChance(cf.read_repair_chance).dclocalReadRepairChance(cf.dclocal_read_repair_chance).replicateOnWrite(cf.replicate_on_write).gcGraceSeconds(cf.gc_grace_seconds).defaultValidator(validator).keyValidator(keyValidator).columnMetadata(column_metadata).compressionParameters(cp).bloomFilterFpChance(cf.bloom_filter_fp_chance).caching(caching);
    }

    private static <T> List<T> fixAvroRetardation(List<T> array) {
        return new ArrayList<T>(array);
    }

    public String getComment() {
        return this.comment;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepair() {
        return this.dcLocalReadRepairChance;
    }

    public double getMergeShardsChance() {
        return this.mergeShardsChance;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public ByteBuffer getKeyName() {
        return this.keyAlias == null ? DEFAULT_KEY_NAME : this.keyAlias;
    }

    public ByteBuffer getKeyAlias() {
        return this.keyAlias;
    }

    public List<ByteBuffer> getColumnAliases() {
        return this.columnAliases;
    }

    public ByteBuffer getValueAlias() {
        return this.valueAlias;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Map<ByteBuffer, ColumnDefinition> getColumn_metadata() {
        return Collections.unmodifiableMap(this.column_metadata);
    }

    public AbstractType<?> getComparatorFor(ByteBuffer superColumnName) {
        return superColumnName == null ? this.comparator : this.subcolumnComparator;
    }

    public Double getBloomFilterFpChance() {
        return this.bloomFilterFpChance;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.ksName, (Object)rhs.ksName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append(this.comparator, rhs.comparator).append(this.subcolumnComparator, rhs.subcolumnComparator).append((Object)this.comment, (Object)rhs.comment).append(this.readRepairChance, rhs.readRepairChance).append(this.dcLocalReadRepairChance, rhs.dcLocalReadRepairChance).append(this.replicateOnWrite, rhs.replicateOnWrite).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append(this.defaultValidator, rhs.defaultValidator).append(this.keyValidator, rhs.keyValidator).append(this.minCompactionThreshold, rhs.minCompactionThreshold).append(this.maxCompactionThreshold, rhs.maxCompactionThreshold).append(this.cfId.intValue(), rhs.cfId.intValue()).append(this.column_metadata, rhs.column_metadata).append(this.mergeShardsChance, rhs.mergeShardsChance).append((Object)this.keyAlias, (Object)rhs.keyAlias).append(this.columnAliases, rhs.columnAliases).append((Object)this.valueAlias, (Object)rhs.valueAlias).append(this.compactionStrategyClass, rhs.compactionStrategyClass).append(this.compactionStrategyOptions, rhs.compactionStrategyOptions).append((Object)this.compressionParameters, (Object)rhs.compressionParameters).append((Object)this.bloomFilterFpChance, (Object)rhs.bloomFilterFpChance).append((Object)this.caching, (Object)rhs.caching).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append(this.comparator).append(this.subcolumnComparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.replicateOnWrite).append(this.gcGraceSeconds).append(this.defaultValidator).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append(this.mergeShardsChance).append((Object)this.keyAlias).append(this.columnAliases).append((Object)this.valueAlias).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append((Object)this.bloomFilterFpChance).append((Object)this.caching).toHashCode();
    }

    public AbstractType<?> getValueValidator(ByteBuffer column) {
        return this.getValueValidator(this.column_metadata.get(column));
    }

    public AbstractType<?> getValueValidator(ColumnDefinition columnDefinition) {
        return columnDefinition == null ? this.defaultValidator : columnDefinition.getValidator();
    }

    public static void applyImplicitDefaults(org.apache.cassandra.thrift.CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetReplicate_on_write()) {
            cf_def.setReplicate_on_write(true);
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (!cf_def.isSetMerge_shards_chance()) {
            cf_def.setMerge_shards_chance(0.1);
        }
        if (null == cf_def.compaction_strategy) {
            cf_def.compaction_strategy = DEFAULT_COMPACTION_STRATEGY_CLASS;
        }
        if (null == cf_def.compaction_strategy_options) {
            cf_def.compaction_strategy_options = Collections.emptyMap();
        }
        if (!cf_def.isSetCompression_options()) {
            cf_def.setCompression_options((Map)new HashMap<String, String>(){
                {
                    this.put("sstable_compression", SnappyCompressor.class.getCanonicalName());
                }
            });
        }
        if (!cf_def.isSetDclocal_read_repair_chance()) {
            cf_def.setDclocal_read_repair_chance(0.0);
        }
    }

    public static CFMetaData fromThrift(org.apache.cassandra.thrift.CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, TypeParser.parse(cf_def.comparator_type), cf_def.subcomparator_type == null ? null : TypeParser.parse(cf_def.subcomparator_type), cf_def.isSetId() ? cf_def.id : Schema.instance.nextCFId());
        if (cf_def.isSetGc_grace_seconds()) {
            newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
        }
        if (cf_def.isSetMin_compaction_threshold()) {
            newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
        }
        if (cf_def.isSetMax_compaction_threshold()) {
            newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
        }
        if (cf_def.isSetMerge_shards_chance()) {
            newCFMD.mergeShardsChance(cf_def.merge_shards_chance);
        }
        if (cf_def.isSetKey_alias()) {
            newCFMD.keyAlias(cf_def.key_alias);
        }
        if (cf_def.isSetColumn_aliases() && cf_def.column_aliases != null) {
            newCFMD.columnAliases(cf_def.column_aliases);
        }
        if (cf_def.isSetValue_alias()) {
            newCFMD.valueAlias(cf_def.value_alias);
        }
        if (cf_def.isSetKey_validation_class()) {
            newCFMD.keyValidator(TypeParser.parse(cf_def.key_validation_class));
        }
        if (cf_def.isSetCompaction_strategy()) {
            newCFMD.compactionStrategyClass = CFMetaData.createCompactionStrategy(cf_def.compaction_strategy);
        }
        if (cf_def.isSetCompaction_strategy_options()) {
            newCFMD.compactionStrategyOptions(new HashMap<String, String>(cf_def.compaction_strategy_options));
        }
        if (cf_def.isSetBloom_filter_fp_chance()) {
            newCFMD.bloomFilterFpChance(cf_def.bloom_filter_fp_chance);
        }
        if (cf_def.isSetCaching()) {
            newCFMD.caching(Caching.fromString(cf_def.caching));
        }
        if (cf_def.isSetDclocal_read_repair_chance()) {
            newCFMD.dclocalReadRepairChance(cf_def.dclocal_read_repair_chance);
        }
        CompressionParameters cp = CompressionParameters.create(cf_def.compression_options);
        return newCFMD.comment(cf_def.comment).readRepairChance(cf_def.read_repair_chance).replicateOnWrite(cf_def.replicate_on_write).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).keyValidator(TypeParser.parse(cf_def.key_validation_class)).columnMetadata(ColumnDefinition.fromThrift(cf_def.column_metadata)).compressionParameters(cp).validate();
    }

    public void reload() throws IOException {
        Row cfDefRow = SystemTable.readSchemaRow(this.ksName, this.cfName);
        if (cfDefRow.cf == null || cfDefRow.cf.isEmpty()) {
            throw new IOException(String.format("%s not found in the schema definitions table.", this.ksName + ":" + this.cfName));
        }
        try {
            this.apply(CFMetaData.fromSchema(cfDefRow.cf));
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public void apply(org.apache.cassandra.thrift.CfDef cf_def) throws ConfigurationException {
        AbstractType<?> newSubComparator;
        logger.debug("applying {} to {}", (Object)cf_def, (Object)this);
        if (!cf_def.keyspace.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cf_def.keyspace, this.ksName));
        }
        if (!cf_def.name.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cf_def.name, this.cfName));
        }
        if (cf_def.id != this.cfId) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cf_def.id, this.cfId));
        }
        if (!cf_def.column_type.equals(this.cfType.name())) {
            throw new ConfigurationException("types do not match.");
        }
        AbstractType<?> newComparator = TypeParser.parse(cf_def.comparator_type);
        AbstractType<?> abstractType = newSubComparator = cf_def.subcomparator_type == null || cf_def.subcomparator_type.equals("") ? null : TypeParser.parse(cf_def.subcomparator_type);
        if (!newComparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException("comparators do not match or are not compatible.");
        }
        if (newSubComparator == null) {
            if (this.subcolumnComparator != null) {
                throw new ConfigurationException("subcolumncomparators do not match.");
            }
        } else if (!newSubComparator.isCompatibleWith(this.subcolumnComparator)) {
            throw new ConfigurationException("subcolumncomparators do not match or are note compatible.");
        }
        this.comparator = newComparator;
        this.subcolumnComparator = newSubComparator;
        CFMetaData.validateMinMaxCompactionThresholds(cf_def);
        this.comment = CFMetaData.enforceCommentNotNull(cf_def.comment);
        this.readRepairChance = cf_def.read_repair_chance;
        if (cf_def.isSetDclocal_read_repair_chance()) {
            this.dcLocalReadRepairChance = cf_def.dclocal_read_repair_chance;
        }
        this.replicateOnWrite = cf_def.replicate_on_write;
        this.gcGraceSeconds = cf_def.gc_grace_seconds;
        this.defaultValidator = TypeParser.parse(cf_def.default_validation_class);
        this.keyValidator = TypeParser.parse(cf_def.key_validation_class);
        this.minCompactionThreshold = cf_def.min_compaction_threshold;
        this.maxCompactionThreshold = cf_def.max_compaction_threshold;
        this.mergeShardsChance = cf_def.merge_shards_chance;
        this.keyAlias = cf_def.key_alias;
        this.columnAliases = cf_def.column_aliases;
        this.valueAlias = cf_def.value_alias;
        if (cf_def.isSetBloom_filter_fp_chance()) {
            this.bloomFilterFpChance = cf_def.bloom_filter_fp_chance;
        }
        this.caching = Caching.fromString(cf_def.caching);
        if (!cf_def.isSetColumn_metadata()) {
            cf_def.setColumn_metadata(new ArrayList());
        }
        HashSet<ByteBuffer> toRemove = new HashSet<ByteBuffer>();
        HashSet<ByteBuffer> newColumns = new HashSet<ByteBuffer>();
        HashSet<org.apache.cassandra.thrift.ColumnDef> toAdd = new HashSet<org.apache.cassandra.thrift.ColumnDef>();
        for (org.apache.cassandra.thrift.ColumnDef columnDef : cf_def.column_metadata) {
            newColumns.add(columnDef.name);
            if (this.column_metadata.containsKey(columnDef.name)) continue;
            toAdd.add(columnDef);
        }
        for (ByteBuffer byteBuffer : this.column_metadata.keySet()) {
            if (newColumns.contains(byteBuffer)) continue;
            toRemove.add(byteBuffer);
        }
        for (ByteBuffer byteBuffer : toRemove) {
            this.column_metadata.remove(byteBuffer);
        }
        for (org.apache.cassandra.thrift.ColumnDef columnDef : cf_def.column_metadata) {
            ColumnDefinition oldDef = this.column_metadata.get(columnDef.name);
            if (oldDef == null) continue;
            oldDef.setValidator(TypeParser.parse(columnDef.validation_class));
            oldDef.setIndexType(columnDef.index_type == null ? null : IndexType.valueOf((String)columnDef.index_type.name()), columnDef.index_options);
            oldDef.setIndexName(columnDef.index_name == null ? null : columnDef.index_name);
        }
        for (org.apache.cassandra.thrift.ColumnDef columnDef : toAdd) {
            AbstractType<?> dValidClass = TypeParser.parse(columnDef.validation_class);
            ColumnDefinition cd = new ColumnDefinition(columnDef.name, dValidClass, columnDef.index_type == null ? null : IndexType.valueOf((String)columnDef.index_type.name()), columnDef.index_options, columnDef.index_name == null ? null : columnDef.index_name);
            this.column_metadata.put(cd.name, cd);
        }
        if (cf_def.compaction_strategy != null) {
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(cf_def.compaction_strategy);
        }
        if (null != cf_def.compaction_strategy_options) {
            this.compactionStrategyOptions = new HashMap<String, String>();
            for (Map.Entry entry : cf_def.compaction_strategy_options.entrySet()) {
                this.compactionStrategyOptions.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.compressionParameters = CompressionParameters.create(cf_def.compression_options);
        logger.debug("application result is {}", (Object)this);
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className;
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create Compaction Strategy of type " + className, e);
        }
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public org.apache.cassandra.thrift.CfDef toThrift() {
        org.apache.cassandra.thrift.CfDef def = new org.apache.cassandra.thrift.CfDef(this.ksName, this.cfName);
        def.setId(this.cfId.intValue());
        def.setColumn_type(this.cfType.name());
        def.setComparator_type(this.comparator.toString());
        if (this.subcolumnComparator != null) {
            assert (this.cfType == ColumnFamilyType.Super) : String.format("%s CF %s should not have subcomparator %s defined", new Object[]{this.cfType, this.cfName, this.subcolumnComparator});
            def.setSubcomparator_type(this.subcolumnComparator.toString());
        }
        def.setComment(CFMetaData.enforceCommentNotNull(this.comment));
        def.setRead_repair_chance(this.readRepairChance);
        def.setDclocal_read_repair_chance(this.dcLocalReadRepairChance);
        def.setReplicate_on_write(this.replicateOnWrite);
        def.setGc_grace_seconds(this.gcGraceSeconds);
        def.setDefault_validation_class(this.defaultValidator == null ? null : this.defaultValidator.toString());
        def.setKey_validation_class(this.keyValidator.toString());
        def.setMin_compaction_threshold(this.minCompactionThreshold);
        def.setMax_compaction_threshold(this.maxCompactionThreshold);
        def.setMerge_shards_chance(this.mergeShardsChance);
        def.setKey_alias(this.keyAlias);
        ArrayList<org.apache.cassandra.thrift.ColumnDef> column_meta = new ArrayList<org.apache.cassandra.thrift.ColumnDef>(this.column_metadata.size());
        for (ColumnDefinition cd : this.column_metadata.values()) {
            org.apache.cassandra.thrift.ColumnDef tcd = new org.apache.cassandra.thrift.ColumnDef();
            tcd.setIndex_name(cd.getIndexName());
            tcd.setIndex_type(cd.getIndexType());
            tcd.setIndex_options(cd.getIndexOptions());
            tcd.setName(cd.name);
            tcd.setValidation_class(cd.getValidator().toString());
            column_meta.add(tcd);
        }
        def.setColumn_metadata(column_meta);
        def.setCompaction_strategy(this.compactionStrategyClass.getName());
        def.setCompaction_strategy_options(new HashMap<String, String>(this.compactionStrategyOptions));
        def.setCompression_options(this.compressionParameters.asThriftOptions());
        if (this.bloomFilterFpChance != null) {
            def.setBloom_filter_fp_chance(this.bloomFilterFpChance.doubleValue());
        }
        def.setCaching(this.caching.toString());
        return def;
    }

    public static void validateMinMaxCompactionThresholds(org.apache.cassandra.thrift.CfDef cf_def) throws ConfigurationException {
        if (cf_def.isSetMin_compaction_threshold() && cf_def.isSetMax_compaction_threshold()) {
            if (cf_def.min_compaction_threshold > cf_def.max_compaction_threshold && cf_def.max_compaction_threshold != 0) {
                throw new ConfigurationException("min_compaction_threshold cannot be greater than max_compaction_threshold");
            }
        } else if (cf_def.isSetMin_compaction_threshold()) {
            if (cf_def.min_compaction_threshold > 32) {
                throw new ConfigurationException("min_compaction_threshold cannot be greater than max_compaction_threshold (default 32)");
            }
        } else if (cf_def.isSetMax_compaction_threshold() && cf_def.max_compaction_threshold < 4 && cf_def.max_compaction_threshold != 0) {
            throw new ConfigurationException("max_compaction_threshold cannot be less than min_compaction_threshold");
        }
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.column_metadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public static void addDefaultIndexNames(org.apache.cassandra.thrift.CfDef cf_def) throws InvalidRequestException {
        if (cf_def.column_metadata == null) {
            return;
        }
        try {
            AbstractType<?> comparator = TypeParser.parse(cf_def.comparator_type);
            for (org.apache.cassandra.thrift.ColumnDef column : cf_def.column_metadata) {
                if (column.index_type == null || column.index_name != null) continue;
                column.index_name = CFMetaData.getDefaultIndexName(cf_def.name, comparator, column.name);
            }
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public static String getDefaultIndexName(String cfName, AbstractType<?> comparator, ByteBuffer columnName) {
        return (cfName + "_" + comparator.getString(columnName) + "_idx").replaceAll("\\W", "");
    }

    public IColumnSerializer getColumnSerializer() {
        if (this.cfType == ColumnFamilyType.Standard) {
            return Column.serializer();
        }
        return SuperColumn.serializer(this.subcolumnComparator);
    }

    public CFMetaData validate() throws ConfigurationException {
        if (this.comparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.subcolumnComparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid sub-column comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.defaultValidator instanceof CounterColumnType) {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (def.getValidator() instanceof CounterColumnType) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + this.comparator.getString(def.name) + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (!(def.getValidator() instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + this.comparator.getString(def.name) + ") in a non counter column family");
            }
        }
        return this;
    }

    public RowMutation diff(org.apache.cassandra.thrift.CfDef newState, long modificationTimestamp) throws ConfigurationException {
        org.apache.cassandra.thrift.CfDef curState = this.toThrift();
        RowMutation m = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        for (CfDef._Fields field : CfDef._Fields.values()) {
            Object newValue;
            if (field.equals((Object)CfDef._Fields.COLUMN_METADATA)) continue;
            Object curValue = curState.isSet(field) ? curState.getFieldValue(field) : null;
            Object object = newValue = newState.isSet(field) ? newState.getFieldValue(field) : null;
            if (Objects.equal((Object)curValue, (Object)newValue)) continue;
            m.add(new QueryPath("schema_columnfamilies", null, MigrationHelper.compositeNameFor(curState.name, field.getFieldName())), MigrationHelper.valueAsBytes(newValue), modificationTimestamp);
        }
        AbstractType<?> nameComparator = this.cfType.equals((Object)ColumnFamilyType.Super) ? this.subcolumnComparator : this.comparator;
        MapDifference columnDiff = Maps.difference(this.column_metadata, ColumnDefinition.fromThrift(newState.column_metadata));
        Map<ByteBuffer, org.apache.cassandra.thrift.ColumnDef> columnDefMap = ColumnDefinition.toMap(newState.column_metadata);
        for (ByteBuffer name : columnDiff.entriesOnlyOnLeft().keySet()) {
            ColumnDefinition.deleteFromSchema(m, curState.name, nameComparator, name, modificationTimestamp);
        }
        for (ByteBuffer name : columnDiff.entriesOnlyOnRight().keySet()) {
            ColumnDefinition.addToSchema(m, curState.name, nameComparator, columnDefMap.get(name), modificationTimestamp);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition.addToSchema(m, curState.name, nameComparator, columnDefMap.get(name), modificationTimestamp);
        }
        return m;
    }

    public RowMutation dropFromSchema(long timestamp) {
        RowMutation m = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        for (CfDef._Fields field : CfDef._Fields.values()) {
            m.delete(new QueryPath("schema_columnfamilies", null, MigrationHelper.compositeNameFor(this.cfName, field.getFieldName())), timestamp);
        }
        for (ColumnDefinition columnDefinition : this.column_metadata.values()) {
            ColumnDefinition.deleteFromSchema(m, this.cfName, this.comparator, columnDefinition.name, timestamp);
        }
        return m;
    }

    public RowMutation toSchema(long timestamp) throws ConfigurationException {
        RowMutation mutation = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        CFMetaData.toSchema(mutation, this.toThrift(), timestamp);
        return mutation;
    }

    public static void toSchema(RowMutation mutation, org.apache.cassandra.thrift.CfDef cfDef, long timestamp) throws ConfigurationException {
        CFMetaData.applyImplicitDefaults(cfDef);
        for (CfDef._Fields field : CfDef._Fields.values()) {
            if (field.equals((Object)CfDef._Fields.COLUMN_METADATA)) continue;
            Object value = cfDef.isSet(field) ? cfDef.getFieldValue(field) : null;
            mutation.add(new QueryPath("schema_columnfamilies", null, MigrationHelper.compositeNameFor(cfDef.name, field.getFieldName())), MigrationHelper.valueAsBytes(value), timestamp);
        }
        if (!cfDef.isSetColumn_metadata()) {
            return;
        }
        AbstractType<?> comparator = CFMetaData.getColumnDefinitionComparator(cfDef);
        for (org.apache.cassandra.thrift.ColumnDef columnDef : cfDef.column_metadata) {
            ColumnDefinition.addToSchema(mutation, cfDef.name, comparator, columnDef, timestamp);
        }
    }

    public static AbstractType<?> getColumnDefinitionComparator(org.apache.cassandra.thrift.CfDef cfDef) throws ConfigurationException {
        AbstractType<?> cfComparator = TypeParser.parse(cfDef.column_type.equals("Super") ? cfDef.subcomparator_type : cfDef.comparator_type);
        if (cfComparator instanceof CompositeType) {
            List<AbstractType<?>> types = ((CompositeType)cfComparator).types;
            return types.get(types.size() - 1);
        }
        return cfComparator;
    }

    public static org.apache.cassandra.thrift.CfDef fromSchema(ColumnFamily serializedCfDef) throws IOException {
        org.apache.cassandra.thrift.CfDef cfDef = CFMetaData.fromSchemaNoColumnDefinition(serializedCfDef);
        ColumnFamily serializedColumnDefinitions = ColumnDefinition.readSchema(cfDef.keyspace, cfDef.name);
        return CFMetaData.addColumnDefinitionSchema(cfDef, serializedColumnDefinitions);
    }

    static org.apache.cassandra.thrift.CfDef fromSchemaNoColumnDefinition(ColumnFamily serializedCfDef) {
        assert (serializedCfDef != null);
        org.apache.cassandra.thrift.CfDef cfDef = new org.apache.cassandra.thrift.CfDef();
        AbstractType<?> sysComparator = serializedCfDef.getComparator();
        for (IColumn cfAttr : serializedCfDef.getSortedColumns()) {
            if (cfAttr == null || cfAttr.isMarkedForDelete()) continue;
            String[] attr = sysComparator.getString(cfAttr.name()).split(":");
            assert (attr.length == 2);
            CfDef._Fields field = CfDef._Fields.findByName((String)attr[1]);
            cfDef.setFieldValue(field, MigrationHelper.deserializeValue(cfAttr.value(), MigrationHelper.getValueClass(org.apache.cassandra.thrift.CfDef.class, field.getFieldName())));
        }
        return cfDef;
    }

    static org.apache.cassandra.thrift.CfDef addColumnDefinitionSchema(org.apache.cassandra.thrift.CfDef cfDef, ColumnFamily serializedColumnDefinitions) {
        for (org.apache.cassandra.thrift.ColumnDef columnDef : ColumnDefinition.fromSchema(serializedColumnDefinitions)) {
            cfDef.addToColumn_metadata(columnDef);
        }
        return cfDef;
    }

    private void updateCfDef() {
        this.cqlCfDef = new CFDefinition(this);
    }

    public CFDefinition getCfDef() {
        assert (this.cqlCfDef != null);
        return this.cqlCfDef;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", this.comparator).append("subcolumncomparator", this.subcolumnComparator).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dclocalReadRepairChance", this.dcLocalReadRepairChance).append("replicateOnWrite", this.replicateOnWrite).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", this.defaultValidator).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("mergeShardsChance", this.mergeShardsChance).append("keyAlias", (Object)this.keyAlias).append("columnAliases", this.columnAliases).append("valueAlias", (Object)this.keyAlias).append("column_metadata", this.column_metadata).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionOptions", this.compressionParameters.asThriftOptions()).append("bloomFilterFpChance", (Object)this.bloomFilterFpChance).append("caching", (Object)this.caching).toString();
    }

    public static enum Caching {
        ALL,
        KEYS_ONLY,
        ROWS_ONLY,
        NONE;


        public static Caching fromString(String cache) throws ConfigurationException {
            try {
                return Caching.valueOf(cache.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("%s not found, available types: %s.", cache, StringUtils.join((Object[])Caching.values(), (String)", ")));
            }
        }
    }
}

