/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Locale;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnIdentifier
implements Comparable<ColumnIdentifier> {
    public final ByteBuffer key;
    private final String text;

    public ColumnIdentifier(String rawText, boolean keepCase) {
        this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        this.key = ByteBufferUtil.bytes(this.text);
    }

    public ColumnIdentifier(ByteBuffer key) {
        try {
            this.key = key;
            this.text = ByteBufferUtil.string(key);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier that = (ColumnIdentifier)o;
        return this.key.equals(that.key);
    }

    public String toString() {
        return this.text;
    }

    @Override
    public int compareTo(ColumnIdentifier other) {
        return this.key.compareTo(other.key);
    }
}

