/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;

class RangeSliceCommandSerializer
implements IVersionedSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutput dos, int version) throws IOException {
        dos.writeUTF(sliceCommand.keyspace);
        dos.writeUTF(sliceCommand.column_family);
        ByteBuffer sc = sliceCommand.super_column;
        dos.writeInt(sc == null ? 0 : sc.remaining());
        if (sc != null) {
            ByteBufferUtil.write(sc, dos);
        }
        TSerializer ser = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        FBUtilities.serialize(ser, (TBase)sliceCommand.predicate, dos);
        if (version >= 4) {
            if (sliceCommand.row_filter == null) {
                dos.writeInt(0);
            } else {
                dos.writeInt(sliceCommand.row_filter.size());
                for (IndexExpression expr : sliceCommand.row_filter) {
                    FBUtilities.serialize(ser, (TBase)expr, dos);
                }
            }
        }
        AbstractBounds.serializer().serialize(sliceCommand.range, dos, version);
        dos.writeInt(sliceCommand.maxResults);
        if (version >= 4) {
            dos.writeBoolean(sliceCommand.maxIsColumns);
        }
    }

    @Override
    public RangeSliceCommand deserialize(DataInput dis, int version) throws IOException {
        String keyspace = dis.readUTF();
        String columnFamily = dis.readUTF();
        int scLength = dis.readInt();
        ByteBuffer superColumn = null;
        if (scLength > 0) {
            byte[] buf = new byte[scLength];
            dis.readFully(buf);
            superColumn = ByteBuffer.wrap(buf);
        }
        TDeserializer dser = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        SlicePredicate pred = new SlicePredicate();
        FBUtilities.deserialize(dser, (TBase)pred, dis);
        ArrayList<IndexExpression> rowFilter = null;
        if (version >= 4) {
            int filterCount = dis.readInt();
            rowFilter = new ArrayList<IndexExpression>(filterCount);
            for (int i = 0; i < filterCount; ++i) {
                IndexExpression expr = new IndexExpression();
                FBUtilities.deserialize(dser, (TBase)expr, dis);
                rowFilter.add(expr);
            }
        }
        AbstractBounds<RowPosition> range = ((AbstractBounds)AbstractBounds.serializer().deserialize(dis, version)).toRowBounds();
        int maxResults = dis.readInt();
        boolean maxIsColumns = false;
        if (version >= 4) {
            maxIsColumns = dis.readBoolean();
        }
        return new RangeSliceCommand(keyspace, columnFamily, superColumn, pred, range, rowFilter, maxResults, maxIsColumns);
    }

    @Override
    public long serializedSize(RangeSliceCommand rangeSliceCommand, int version) {
        throw new UnsupportedOperationException();
    }
}

