/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.MigrationHelper;

public class AddColumnFamily
extends Migration {
    private final CFMetaData cfm;

    public AddColumnFamily(CFMetaData cfm) throws ConfigurationException {
        super(System.nanoTime());
        KSMetaData ksm = Schema.instance.getTableDefinition(cfm.ksName);
        if (ksm == null) {
            throw new ConfigurationException(String.format("Can't add ColumnFamily '%s' to Keyspace '%s': Keyspace does not exist.", cfm.cfName, cfm.ksName));
        }
        if (ksm.cfMetaData().containsKey(cfm.cfName)) {
            throw new ConfigurationException(String.format("Can't add ColumnFamily '%s' to Keyspace '%s': Already exists.", cfm.cfName, cfm.ksName));
        }
        if (!Migration.isLegalName(cfm.cfName)) {
            throw new ConfigurationException("Can't add ColumnFamily '%s' to Keyspace '%s': Invalid ColumnFamily name.");
        }
        this.cfm = cfm;
    }

    @Override
    protected void applyImpl() throws ConfigurationException, IOException {
        MigrationHelper.addColumnFamily(this.cfm, this.timestamp);
    }

    public String toString() {
        return "Add column family: " + this.cfm.toString();
    }
}

