/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.MigrationHelper;

public class DropKeyspace
extends Migration {
    private final String name;

    public DropKeyspace(String name) throws ConfigurationException {
        super(System.nanoTime());
        KSMetaData ksm = Schema.instance.getTableDefinition(name);
        if (ksm == null) {
            throw new ConfigurationException("Can't drop keyspace '" + name + "' because it does not exist.");
        }
        this.name = name;
    }

    @Override
    protected void applyImpl() throws ConfigurationException, IOException {
        MigrationHelper.dropKeyspace(this.name, this.timestamp);
    }

    public String toString() {
        return "Drop keyspace: " + this.name;
    }
}

